<?php

use Illuminate\Support\Facades\Route;

// Route::get('/', function () {
//     return view('welcome');
// });


Route::get('/', [App\Http\Controllers\HomeController::class, 'index'])->name('/');
Route::get('home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

Route::middleware(['guest', 'PreventBackHistory'])->group(function (): void {
    Route::get('login', [App\Http\Controllers\AuthController::class, 'showLogin'])->name('login');
    Route::post('signin', [App\Http\Controllers\AuthController::class, 'signin'])->name('signin');
    Route::get('/register', [App\Http\Controllers\AuthController::class, 'showRegister'])->name('register');
    Route::post('/register', [App\Http\Controllers\AuthController::class, 'register'])->name('register');
});

Route::get('get_slots', [App\Http\Controllers\BookingController::class, 'getSlots'])->name('get-slots');

Route::middleware(['auth', 'PreventBackHistory'])->group(function (): void {
    Route::get('edit-profile', [App\Http\Controllers\HomeController::class, 'editProfile'])->name('edit-profile');
    Route::post('logout', [App\Http\Controllers\AuthController::class, 'logout'])->name('logout');
    Route::get('show-change-password', [App\Http\Controllers\AuthController::class, 'showChangePassword'])->name('show-change-password');
    Route::post('change-password', [App\Http\Controllers\AuthController::class, 'changePassword'])->name('change-password');
    Route::get('/dashboard', [App\Http\Controllers\HomeController::class, 'dashboard'])->name('dashboard');
    Route::resource('booking_slots', App\Http\Controllers\Masters\BookingSlotController::class);
    Route::resource('special_booking_slots', App\Http\Controllers\Masters\SpecialBookingController::class);

    Route::post('checkout', [App\Http\Controllers\BookingController::class, 'checkout'])->name('checkout');
    Route::post('book-service', [App\Http\Controllers\BookingController::class, 'bookService'])->name('book-service');
    Route::get('my-account', [App\Http\Controllers\AuthController::class, 'myAccount'])->name('my-account.show');
    Route::get('my-booking', [App\Http\Controllers\HomeController::class, 'myBooking'])->name('my-booking.show');
    Route::get('booked-list', [App\Http\Controllers\BookingController::class, 'bookedList'])->name('booked-list');
    Route::post('/booking/confirm', [App\Http\Controllers\BookingController::class, 'confirmBooking'])->name('booking.confirm');

    // Individual slot routes (for backward compatibility)
    Route::post('/booking/{id}/cancel', [App\Http\Controllers\BookingController::class, 'bookingCancel'])->name('booking-cancel');
    Route::get('/booking/{id}/reschedule', [App\Http\Controllers\BookingController::class, 'reschedule'])->name('booking.reschedule');
    Route::post('/booking/{id}/reschedule', [App\Http\Controllers\BookingController::class, 'processReschedule'])->name('booking.process-reschedule');

    // Group-based routes (for grouped bookings)
    Route::post('/booking/group/{groupId}/cancel', [App\Http\Controllers\BookingController::class, 'cancelBookingGroup'])->name('booking.cancel.group');
    Route::get('/booking/group/{groupId}/reschedule', [App\Http\Controllers\BookingController::class, 'rescheduleGroup'])->name('booking.reschedule.group');
    Route::post('/booking/group/{groupId}/reschedule', [App\Http\Controllers\BookingController::class, 'processRescheduleGroup'])->name('booking.process-reschedule.group');

    Route::post('/booking/reschedule/confirm', [App\Http\Controllers\BookingController::class, 'confirmReschedule'])->name('booking.reschedule.confirm');


    Route::resource('users', App\Http\Controllers\UserController::class);
    Route::get('users/{user}/toggle', [App\Http\Controllers\UserController::class, 'toggle'])->name('users.toggle');
    Route::get('users/{user}/retire', [App\Http\Controllers\UserController::class, 'retire'])->name('users.retire');
    Route::put('users/{user}/change-password', [App\Http\Controllers\UserController::class, 'changePassword'])->name('users.change-password');
    Route::get('users/{user}/get-role', [App\Http\Controllers\UserController::class, 'getRole'])->name('users.get-role');
    Route::put('users/{user}/assign-role', [App\Http\Controllers\UserController::class, 'assignRole'])->name('users.assign-role');
    Route::put('users-update/{user}', [App\Http\Controllers\UserController::class, 'userUpdate'])->name('users-detail.update');
    // Route::resource('roles', App\Http\Controllers\RoleController::class);

});
