<x-user.layout>

    @push('styles')
        <style>
            .hover-card {
                transition: all 0.3s ease;
                border: 1px solid rgba(0, 0, 0, 0.05);
            }

            .hover-card:hover:not(.opacity-75) {
                transform: translateY(-5px);
                box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1) !important;
            }

            .icon-box {
                width: 50px;
                height: 50px;
                display: flex;
                align-items: center;
                justify-content: center;
            }

            .hover-danger:hover {
                background-color: #dc3545;
                color: #fff;
            }

            .bg-peach {
                background-color: #fff6f3;
            }

            .pointer-events-none {
                pointer-events: none;
            }
        </style>
    @endpush

    <div class="breadcrumb-area bg-peach position-relative z-1 pb-0">
        <div class="container text-center">
            <h2 class="section-title style-two">My Bookings</h2>
            <ul class="br-menu list-unstyled mb-0">
                <li><a href="{{ route('home') }}">Home</a></li>
                <li>My Bookings</li>
            </ul>
        </div>
    </div>

    <div class="container py-5">
        <div class="border-0 rounded-4 bg-transparent">
            <div class="card-header bg-transparent p-3">
                <h5 class="mb-0">My Bookings</h5>
            </div>

            {{-- <div class="">
                @if ($bookings->isEmpty())
                <div class="text-center py-5">
                    <p class="text-muted mb-0">You haven’t booked any slots yet.</p>
                </div>
                @else
                <div class="table-responsive">
                    <table class="table table-bordered align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>#</th>
                                <th>Service</th>
                                <th>Date</th>
                                <th>Time</th>
                                <th>Amount</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($bookings as $index => $booking)
                            <tr>
                                <td>{{ $index + 1 }}</td>
                                <td>{{ $booking->bookingFor->service ?? 'N/A' }}</td>
                                <td>{{ \Carbon\Carbon::parse($booking->date)->format('d M Y') }}</td>
                                <td>{{ $booking->time }}</td>
                                <td>₹{{ $booking->amount }}</td>
                                <td>
                                    @php
                                    $statusClass = match($booking->status) {
                                    'confirmed' => 'success',
                                    'pending' => 'warning',
                                    'cancelled' => 'danger',
                                    default => 'secondary'
                                    };
                                    @endphp
                                    <span class="badge bg-{{ $statusClass }}">
                                        {{ ucfirst($booking->status ?? 'Pending') }}
                                    </span>
                                </td>
                                <td>
                                    @if ($booking->status !== 'cancelled')
                                    <button class="btn btn-sm btn-danger cancelBookingBtn" data-id="{{ $booking->id }}">
                                        Cancel
                                    </button>
                                    @else
                                    <span class="text-muted">N/A</span>
                                    @endif
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                @endif
            </div> --}}

            <div class="container py-5">
                @if ($bookings->isEmpty())
                    <div class="text-center py-5">
                        <img src="{{ asset('user/assets/img/hero/hero_turf_premium_real.png') }}" alt="No bookings"
                            class="mb-4 opacity-50 grayscale" style="width: 200px; filter: grayscale(100%); opacity: 0.5;">
                        <h4 class="text-secondary fw-bold">No bookings found</h4>
                        <p class="text-muted mb-4">You haven't booked any slots yet. Start your journey now!</p>
                        <a href="{{ route('home') }}" class="btn btn-primary px-4 py-2 rounded-pill shadow-sm">
                            <i class="fas fa-plus-circle me-2"></i> Book a Slot
                        </a>
                    </div>
                @else
                    <div class="row g-4">
                        @foreach ($bookings as $index => $booking)
                            @php
                                $status = (int) $booking->status;
                                // Status: 1 = Confirmed (Active), 2 = Rescheduled, 3 = Cancelled
                                $statusMap = [
                                    0 => ['label' => 'Unbooked', 'class' => 'bg-danger-subtle text-danger border border-danger'],
                                    1 => ['label' => 'Confirmed', 'class' => 'bg-success-subtle text-success border border-success'],
                                    2 => ['label' => 'Rescheduled', 'class' => 'bg-info-subtle text-info border border-info'],
                                    3 => ['label' => 'Cancelled', 'class' => 'bg-secondary-subtle text-secondary border border-secondary'],
                                ];
                                $statusLabel = $statusMap[$status]['label'] ?? 'Unknown';
                                $statusClass = $statusMap[$status]['class'] ?? 'bg-light text-dark';

                                $serviceName = $booking->bookingFor->service ?? '';
                                $isTurf = stripos($serviceName, 'turf') !== false;
                                $serviceIcon = $isTurf ? 'fa-futbol' : 'fa-swimmer';

                                $today = \Carbon\Carbon::now();
                                $bookingDate = \Carbon\Carbon::parse($booking->date);

                                // Booking is in the past if it's before today
                                $isPast = $bookingDate->lt($today->startOfDay());

                                $isCancelled = $booking->status == '3';
                                $isDisabled = $isPast || $isCancelled;
                            @endphp

                            <div class="col-md-6 col-lg-4" data-aos="fade-up" data-aos-delay="{{ $index * 100 }}">
                                <div
                                    class="card h-100 border-0 shadow-sm rounded-4 overflow-hidden position-relative hover-card {{ $isDisabled ? 'opacity-75' : '' }}">
                                    <div class="card-body p-4 position-relative z-1">
                                        <!-- Service Header -->
                                        <div class="d-flex justify-content-between align-items-start mb-4">
                                            <div class="d-flex align-items-center">
                                                <div
                                                    class="icon-box rounded-circle p-3 me-3 {{ $isTurf ? 'bg-success-subtle text-success' : 'bg-info-subtle text-info' }}">
                                                    <i class="fas {{ $serviceIcon }} fa-xl"></i>
                                                </div>
                                                <div>
                                                    <h5 class="fw-bold text-dark mb-1">{{ $serviceName ?: 'Service' }}</h5>
                                                    <small class="text-muted">{{ $booking->slot_count }} slot(s)</small>
                                                </div>
                                            </div>
                                            <span class="badge rounded-pill fw-medium px-3 py-2 {{ $statusClass }}">
                                                {{ $statusLabel }}
                                            </span>
                                        </div>

                                        <!-- Booking Details Grid -->
                                        <div class="booking-details-grid p-3 rounded-3 bg-light mb-4">
                                            <div class="row g-3">
                                                <div class="col-6">
                                                    <small class="text-uppercase text-muted fw-bold"
                                                        style="font-size: 0.7rem;">Date</small>
                                                    <p class="mb-0 fw-semibold text-dark">
                                                        {{ $bookingDate->format('d M, Y') }}
                                                    </p>
                                                </div>
                                                <div class="col-6">
                                                    <small class="text-uppercase text-muted fw-bold"
                                                        style="font-size: 0.7rem;">Slots</small>
                                                    <p class="mb-0 fw-semibold text-dark">
                                                        {{ $booking->slot_count }} hour(s)
                                                    </p>
                                                </div>
                                                <div class="col-12">
                                                    <small class="text-uppercase text-muted fw-bold"
                                                        style="font-size: 0.7rem;">Time Slots</small>
                                                    <div class="d-flex flex-column gap-1 mt-1">
                                                        @foreach ($booking->time_slots as $slot)
                                                            @php
                                                                $startTime = \Carbon\Carbon::parse($slot);
                                                                $endTime = $startTime->copy()->addHour();
                                                            @endphp
                                                            <span
                                                                class="badge bg-primary-subtle text-primary border border-primary rounded-pill px-2 py-1"
                                                                style="font-size: 0.75rem;">
                                                                {{ $startTime->format('g:i A') }} to {{ $endTime->format('g:i A') }}
                                                            </span>
                                                        @endforeach
                                                    </div>
                                                </div>
                                                <div class="col-12 mt-2 pt-2 border-top">
                                                    <div class="d-flex justify-content-between align-items-center">
                                                        <small class="text-uppercase text-muted fw-bold"
                                                            style="font-size: 0.7rem;">Total Paid</small>
                                                        <span
                                                            class="fw-bold text-primary fs-5">₹{{ number_format($booking->total_amount, 2) }}</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Actions Footer -->
                                    <div class="card-footer bg-white border-top-0 p-4 pt-0">
                                        <div class="d-grid gap-2">
                                            @if($isCancelled)
                                                <button class="btn btn-secondary disabled rounded-pill" disabled type="button">
                                                    <i class="fas fa-ban me-2"></i> Cancelled
                                                </button>
                                            @elseif($isPast)
                                                <button class="btn btn-light text-muted disabled rounded-pill" disabled
                                                    type="button">
                                                    <i class="fas fa-check-double me-2"></i> Completed
                                                </button>
                                            @else
                                                <div class="d-flex gap-2">
                                                    <a href="{{ route('booking.reschedule.group', $booking->group_id) }}"
                                                        class="btn btn-outline-primary rounded-pill flex-grow-1">
                                                        <i class="fas fa-sync-alt me-2"></i> Reschedule
                                                    </a>
                                                    <button
                                                        class="btn btn-outline-danger cancelBookingBtn rounded-pill hover-danger flex-grow-1"
                                                        data-group-id="{{ $booking->group_id }}">
                                                        <i class="fas fa-times me-2"></i> Cancel
                                                    </button>
                                                </div>
                                            @endif
                                        </div>
                                    </div>

                                    <!-- Decorative Watermark -->
                                    <div class="position-absolute bottom-0 end-0 opacity-10 mb-n3 me-n3 pointer-events-none"
                                        style="transform: rotate(-15deg); opacity: 0.05;">
                                        <i class="fas {{ $serviceIcon }} fa-8x text-secondary"></i>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @endif
            </div>

        </div>
    </div>


</x-user.layout>


<script>
    $(document).on("click", ".cancelBookingBtn", function () {
        let groupId = $(this).data("group-id");
        console.log("Cancelling group:", groupId);

        Swal.fire({
            title: 'Are you sure?',
            text: "Do you really want to cancel this entire booking? All slots in this booking will be cancelled.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, cancel it!',
            cancelButtonText: 'No, keep it'
        }).then((result) => {
            if (result.isConfirmed) {
                // Proceed with AJAX cancel request
                $.ajax({
                    url: "/booking/group/" + groupId + "/cancel",
                    type: "POST",
                    data: {
                        _token: "{{ csrf_token() }}"
                    },
                    success: function (response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Cancelled!',
                            text: response.message,
                            timer: 2000,
                            showConfirmButton: false
                        }).then(() => {
                            location.reload();
                        });
                    },
                    error: function (xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            text: xhr.responseJSON?.message || 'Something went wrong. Try again.',
                        });
                    }
                });
            }
        });
    });
</script>