<x-user.layout>

    @push('styles')
        <style>
            /* ===== HERO SECTION ENHANCED STYLES ===== */
            .hero-area-enhanced {
                position: relative;
                min-height: 85vh;
                display: flex;
                align-items: center;
                background: linear-gradient(135deg, #0f2027 0%, #203a43 50%, #2c5364 100%);
                /* Premium Dark Theme */
                overflow: hidden;
            }

            /* Animated Gradient Background */
            .hero-gradient-bg {
                position: absolute;
                top: 0;
                left: 0;
                right: 0;
                bottom: 0;
                /* Deep Emerald to Deep Royal Blue */
                background: linear-gradient(-45deg, #0f3d2e, #142850, #001f3f, #052e16);
                background-size: 400% 400%;
                animation: gradientShift 15s ease infinite;
                z-index: 0;
            }

            @keyframes gradientShift {
                0% {
                    background-position: 0% 50%;
                }

                50% {
                    background-position: 100% 50%;
                }

                100% {
                    background-position: 0% 50%;
                }
            }

            /* Floating Shapes */
            .floating-shapes {
                position: absolute;
                width: 100%;
                height: 100%;
                top: 0;
                left: 0;
                z-index: 2;
                pointer-events: none;
            }

            .shape {
                position: absolute;
                border-radius: 50%;
                background: rgba(255, 255, 255, 0.1);
                backdrop-filter: blur(10px);
            }

            .shape-1 {
                width: 300px;
                height: 300px;
                top: 10%;
                left: 5%;
                animation: float 20s ease-in-out infinite;
            }

            .shape-2 {
                width: 200px;
                height: 200px;
                top: 60%;
                left: 15%;
                animation: float 15s ease-in-out infinite reverse;
            }

            .shape-3 {
                width: 150px;
                height: 150px;
                top: 30%;
                right: 10%;
                animation: float 18s ease-in-out infinite;
            }

            .shape-4 {
                width: 250px;
                height: 250px;
                bottom: 10%;
                right: 20%;
                animation: float 22s ease-in-out infinite reverse;
            }

            @keyframes float {

                0%,
                100% {
                    transform: translateY(0) rotate(0deg);
                }

                50% {
                    transform: translateY(-30px) rotate(180deg);
                }
            }

            /* Hero Content */
            .hero-content-enhanced {
                position: relative;
                z-index: 10;
                z-index: 10;
            }

            /* Premium Badge */
            .hero-badge {
                display: inline-flex;
                align-items: center;
                gap: 10px;
                padding: 12px 24px;
                background: rgba(255, 255, 255, 0.15);
                backdrop-filter: blur(10px);
                border-radius: 50px;
                border: 1px solid rgba(255, 255, 255, 0.3);
                color: #fff;
                font-size: 14px;
                font-weight: 500;
                animation: fadeInDown 1s ease;
            }

            .badge-icon {
                font-size: 20px;
                animation: pulse 2s ease infinite;
            }

            @keyframes pulse {

                0%,
                100% {
                    transform: scale(1);
                }

                50% {
                    transform: scale(1.2);
                }
            }

            /* Hero Title */
            .hero-title {
                font-size: clamp(2.5rem, 5vw, 4rem);
                font-weight: 800;
                color: #fff;
                line-height: 1.2;
                text-shadow: 0 4px 20px rgba(0, 0, 0, 0.2);
                animation: fadeInUp 1s ease 0.2s both;
            }

            .gradient-text {
                /* Premium Gold Gradient */
                background: linear-gradient(to right, #bf953f, #fcf6ba, #b38728, #fbf5b7, #aa771c);
                -webkit-background-clip: text;
                -webkit-text-fill-color: transparent;
                background-clip: text;
                position: relative;
                display: inline-block;
                text-shadow: 0 0 10px rgba(191, 149, 63, 0.3);
            }

            /* Hero Description */
            .hero-description {
                font-size: clamp(1rem, 2vw, 1.25rem);
                color: rgba(255, 255, 255, 0.95);
                line-height: 1.8;
                max-width: 600px;
                animation: fadeInUp 1s ease 0.4s both;
            }

            /* CTA Buttons */
            .btn-hero {
                display: inline-flex;
                align-items: center;
                padding: 16px 32px;
                font-size: 16px;
                font-weight: 600;
                border-radius: 50px;
                text-decoration: none;
                transition: all 0.3s ease;
                border: 2px solid transparent;
                position: relative;
                overflow: hidden;
                z-index: 1;
            }

            .btn-hero::before {
                content: '';
                position: absolute;
                top: 0;
                left: -100%;
                width: 100%;
                height: 100%;
                background: rgba(255, 255, 255, 0.2);
                transition: left 0.5s ease;
                z-index: -1;
            }

            .btn-hero:hover::before {
                left: 100%;
            }

            .btn-hero-primary {
                background: #28a745;
                color: #fff;
                box-shadow: 0 8px 25px rgba(40, 167, 69, 0.4);
            }

            .btn-hero-primary:hover {
                background: #218838;
                transform: translateY(-3px);
                box-shadow: 0 12px 35px rgba(40, 167, 69, 0.5);
                color: #fff;
            }

            .btn-hero-secondary {
                background: rgba(255, 255, 255, 0.2);
                color: #fff;
                border-color: rgba(255, 255, 255, 0.5);
                backdrop-filter: blur(10px);
            }

            .btn-hero-secondary:hover {
                background: rgba(255, 255, 255, 0.3);
                border-color: #fff;
                transform: translateY(-3px);
                color: #fff;
            }

            /* Hero Stats */
            .hero-stats {
                animation: fadeInUp 1s ease 0.6s both;
            }

            .stat-item {
                display: flex;
                align-items: center;
                gap: 12px;
                padding: 15px 20px;
                background: rgba(255, 255, 255, 0.15);
                backdrop-filter: blur(10px);
                border-radius: 15px;
                border: 1px solid rgba(255, 255, 255, 0.2);
                transition: all 0.3s ease;
            }

            .stat-item:hover {
                background: rgba(255, 255, 255, 0.25);
                transform: translateY(-5px);
            }

            .stat-icon {
                font-size: 28px;
                color: #ffd89b;
            }

            .stat-number {
                font-size: 24px;
                font-weight: 700;
                color: #fff;
                margin: 0;
                line-height: 1;
            }

            .stat-label {
                font-size: 12px;
                color: rgba(255, 255, 255, 0.8);
                margin: 0;
                text-transform: uppercase;
                letter-spacing: 0.5px;
            }

            /* Hero Images */
            .hero-img-enhanced {
                z-index: 5;
                pointer-events: none;
            }

            .hero-circle-pulse {
                position: absolute;
                right: 10%;
                animation: rotatePulse 20s linear infinite;
                opacity: 0.3;
                max-width: 500px;
            }

            .hero-main-img {
                position: relative;
                animation: floatImage 6s ease-in-out infinite;
                max-width: 600px;
                filter: drop-shadow(0 20px 40px rgba(0, 0, 0, 0.3));
            }

            /* Hero Slideshow */
            /* Hero Slideshow - Full Background Style */
            .hero-slideshow {
                position: absolute;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                z-index: 1;
            }

            .hero-slide-img {
                position: absolute;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                object-fit: cover;
                opacity: 0;
                transition: opacity 2s ease-in-out, transform 10s ease;
                transform: scale(1);
            }

            .hero-slide-img.active {
                opacity: 1;
                z-index: 1;
                transform: scale(1.1);
            }

            /* Dark Overlay for Text Readability */
            .hero-overlay-dark {
                position: absolute;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background: linear-gradient(to right, rgba(15, 32, 39, 0.9) 0%, rgba(32, 58, 67, 0.7) 50%, rgba(44, 83, 100, 0.4) 100%);
                z-index: 2;
            }

            @keyframes rotatePulse {
                0% {
                    transform: rotate(0deg) scale(1);
                }

                50% {
                    transform: rotate(180deg) scale(1.1);
                }

                100% {
                    transform: rotate(360deg) scale(1);
                }
            }

            @keyframes floatImage {

                0%,
                100% {
                    transform: translateY(0);
                }

                50% {
                    transform: translateY(-20px);
                }
            }

            @keyframes fadeInDown {
                from {
                    opacity: 0;
                    transform: translateY(-30px);
                }

                to {
                    opacity: 1;
                    transform: translateY(0);
                }
            }

            @keyframes fadeInUp {
                from {
                    opacity: 0;
                    transform: translateY(30px);
                }

                to {
                    opacity: 1;
                    transform: translateY(0);
                }
            }

            .min-vh-75 {
                min-height: 75vh;
            }

            /* Responsive Design */
            @media (max-width: 991px) {
                .hero-area-enhanced {
                    min-height: auto;
                    padding: 60px 0;
                }

                .hero-title {
                    font-size: 2.5rem;
                }

                .shape {
                    opacity: 0.5;
                }
            }

            @media (max-width: 576px) {
                .hero-title {
                    font-size: 2rem;
                }

                .btn-hero {
                    padding: 14px 24px;
                    font-size: 14px;
                }

                .stat-item {
                    padding: 12px 16px;
                }
            }

            /* ===== SLOT CARD STYLES ===== */
            .slot-card {
                position: relative;
                border: 2px solid #e9ecef;
                border-radius: 12px;
                padding: 12px 15px;
                cursor: pointer;
                transition: all 0.2s ease;
                display: flex;
                align-items: center;
                justify-content: center;
                gap: 8px;
                background: #fff;
                min-width: 100px;
                font-weight: 500;
                user-select: none;
            }

            /* .slot-card:hover:not(.disabled) {
                                                                                                                                                                                                                                                                    transform: translateY(-2px);
                                                                                                                                                                                                                                                                    border: 1px solid black;
                                                                                                                                                                                                                                                                    background: #baffbc;
                                                                                                                                                                                                                                                                    color: #0a387c;
                                                                                                                                                                                                                                                                } */

            .slot-card:hover {
                transform: translateY(-2px);
                border: 1px solid black;
                background: #baffbc;
                color: #0a387c;
            }

            .slot-card .active {
                transform: translateY(-2px) !important;
                border: 1px solid black !important;
                background: #03a509ff !important;
                color: #ffffffff !important;
                box-shadow: 0 2px 8px rgba(40, 167, 70, 0.40);
            }

            .slot-card.selected {
                background: #118d2eff;
                border: 1px solid black !important;
                color: #fff;
                box-shadow: 0 5px 12px rgba(40, 167, 69, 0.50);
            }

            .slot-card.disabled {
                background: #f8f9fa;
                border-color: #dee2e6;
                color: #adb5bd;
                cursor: not-allowed;
                opacity: 0.7;
            }

            .slot-card input {
                display: none;
            }

            /* ===== MODERN BOOKING SECTION STYLES ===== */
            .booking-section-modern {
                background: linear-gradient(180deg, #f8f9fa 0%, #ffffff 100%);
            }

            /* Section Header */
            .section-badge {
                display: inline-block;
                padding: 8px 20px;
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                color: #fff;
                border-radius: 50px;
                font-size: 14px;
                font-weight: 600;
                text-transform: uppercase;
                letter-spacing: 0.5px;
            }

            .section-title {
                font-size: clamp(1.75rem, 4vw, 2.5rem);
                font-weight: 700;
                color: #212529;
            }

            .section-subtitle {
                font-size: 1.1rem;
                color: #6c757d;
                max-width: 600px;
                margin: 0 auto;
            }

            /* Modern Tabs */
            .modern-tabs {
                border: none;
            }

            .modern-tabs li button {
                box-shadow: 2px 4px 12px rgba(0, 0, 0, 0.3) !important;
            }

            .modern-tab-link {
                display: flex;
                align-items: center;
                gap: 15px;
                padding: 20px 30px;
                background: #fff;
                border: 2px solid #e9ecef;
                border-radius: 16px;
                transition: all 0.3s ease;
                min-width: 120px;
            }

            .modern-tab-link:hover {
                transform: translateY(-5px);
                box-shadow: 0 5px 16px rgba(0, 0, 0, 0.3);
                border-color: #667eea;
            }

            .modern-tab-link.active {
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                border-color: transparent;
                box-shadow: 0 10px 30px rgba(43, 80, 243, 0.3);
            }

            .tab-icon {
                width: 50px;
                height: 50px;
                display: flex;
                align-items: center;
                justify-content: center;
                border-radius: 12px;
                font-size: 24px;
                transition: all 0.3s ease;
            }

            .modern-tab-link:not(.active) .turf-icon {
                background: rgba(40, 167, 69, 0.1);
                color: #28a745;
            }

            .modern-tab-link:not(.active) .pool-icon {
                background: rgba(0, 123, 255, 0.1);
                color: #007bff;
            }

            .modern-tab-link.active .tab-icon {
                background: rgba(255, 255, 255, 0.2);
                color: #fff;
            }

            .tab-content-text {
                text-align: left;
            }

            .tab-title {
                font-size: 18px;
                font-weight: 700;
                margin: 0;
                color: #212529;
            }

            .modern-tab-link.active .tab-title {
                color: #fff;
            }

            .tab-subtitle {
                font-size: 13px;
                margin: 0;
                color: #6c757d;
            }

            .modern-tab-link.active .tab-subtitle {
                color: rgba(255, 255, 255, 0.9);
            }

            /* Booking Card */
            .booking-card {
                background: #fff;
                border-radius: 20px;
                padding: 40px;
                box-shadow: 0 10px 40px rgba(0, 0, 0, 0.08);
                max-width: 800px;
                margin: 0 auto;
            }

            /* Form Steps */
            .form-step {
                margin-bottom: 30px;
            }

            .step-header {
                display: flex;
                align-items: center;
                gap: 15px;
                margin-bottom: 20px;
            }

            .step-number {
                width: 40px;
                height: 40px;
                display: flex;
                align-items: center;
                justify-content: center;
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                color: #fff;
                border-radius: 50%;
                font-size: 18px;
                font-weight: 700;
                flex-shrink: 0;
            }

            .step-title {
                font-size: 20px;
                font-weight: 700;
                color: #212529;
                margin: 0;
            }

            .step-content {
                padding-left: 55px;
            }

            /* Date Input */
            .date-input-wrapper {
                position: relative;
                display: flex;
                align-items: center;
            }

            .date-icon {
                position: absolute;
                left: 20px;
                font-size: 20px;
                color: #667eea;
                z-index: 2;
            }

            .modern-input {
                width: 100%;
                padding: 16px 20px 16px 55px;
                border: 2px solid #e9ecef;
                border-radius: 12px;
                font-size: 16px;
                transition: all 0.3s ease;
                background: #f8f9fa;
            }

            .modern-input:focus {
                outline: none;
                border-color: #667eea;
                background: #fff;
                box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.1);
            }

            .modern-input::placeholder {
                color: #adb5bd;
            }

            /* Slots Grid */
            .slots-grid {
                display: grid;
                grid-template-columns: repeat(auto-fill, minmax(120px, 1fr));
                gap: 12px;
            }

            .slots-placeholder {
                grid-column: 1 / -1;
                text-align: center;
                padding: 40px 20px;
                background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
                border-radius: 12px;
                color: #6c757d;
            }

            .slots-placeholder i {
                font-size: 48px;
                margin-bottom: 15px;
                display: block;
                color: #adb5bd;
            }

            .slots-placeholder p {
                margin: 0;
                font-size: 15px;
            }

            /* Modern Buttons */
            .btn-modern {
                display: inline-flex;
                align-items: center;
                justify-content: center;
                padding: 16px 40px;
                font-size: 16px;
                font-weight: 600;
                border-radius: 12px;
                border: none;
                cursor: pointer;
                transition: all 0.3s ease;
                text-decoration: none;
                width: 100%;
                max-width: 400px;
            }

            .btn-modern-success {
                background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
                color: #fff;
                box-shadow: 0 8px 20px rgba(40, 167, 69, 0.3);
            }

            .btn-modern-success:hover {
                transform: translateY(-3px);
                box-shadow: 0 12px 30px rgba(40, 167, 69, 0.4);
            }

            .btn-modern-primary {
                background: linear-gradient(135deg, #007bff 0%, #0056b3 100%);
                color: #fff;
                box-shadow: 0 8px 20px rgba(0, 123, 255, 0.3);
            }

            .btn-modern-primary:hover {
                transform: translateY(-3px);
                box-shadow: 0 12px 30px rgba(0, 123, 255, 0.4);
            }

            /* Enhanced Slot Cards for Grid */
            .slots-grid .slot-card {
                margin: 0;
            }

            /* ===== TWO-COLUMN BOOKING LAYOUT STYLES ===== */

            /* Booking Form Card (Left Column) */
            .booking-form-card {
                background: #fff;
                border-radius: 20px;
                padding: 30px;
                box-shadow: 0 10px 40px rgba(0, 0, 0, 0.08);
                height: 100%;
            }

            .booking-form-title {
                font-size: 22px;
                font-weight: 700;
                color: #212529;
                margin-bottom: 25px;
                padding-bottom: 15px;
                border-bottom: 2px solid #f0f0f0;
            }

            .form-group-modern {
                margin-bottom: 20px;
            }

            .form-label-modern {
                display: block;
                font-size: 15px;
                font-weight: 600;
                color: #495057;
                margin-bottom: 10px;
            }

            .date-input-wrapper {
                position: relative;
            }

            .date-input-wrapper input {
                width: 100%;
                padding: 14px 16px;
                border: 2px solid #e9ecef;
                border-radius: 10px;
                font-size: 15px;
                transition: all 0.3s ease;
            }

            .date-input-wrapper input:focus {
                outline: none;
                border-color: #667eea;
                box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.1);
            }

            /* Compact Slots Grid */
            .slots-grid-compact {
                display: grid;
                grid-template-columns: repeat(auto-fill, minmax(100px, 1fr));
                gap: 10px;
                max-height: 300px;
                overflow-y: auto;
                padding: 10px;
                background: #f8f9fa;
                border-radius: 10px;
            }

            .slots-placeholder-compact {
                grid-column: 1 / -1;
                text-align: center;
                padding: 30px 15px;
                color: #6c757d;
            }

            .slots-placeholder-compact i {
                font-size: 32px;
                margin-bottom: 10px;
                display: block;
                color: #adb5bd;
            }

            .slots-placeholder-compact p {
                margin: 0;
                font-size: 14px;
            }

            /* ===== 7-DAY CALENDAR VIEW STYLES ===== */

            /* Booking Header */
            .booking-header {
                display: block;
                justify-content: space-between;
                align-items: center;
                margin-bottom: 20px;
                flex-wrap: wrap;
                gap: 15px;
            }

            .search-bookings {
                flex: 1;
                min-width: 200px;
                padding: 10px 16px;
                border: 1px solid #e9ecef;
                border-radius: 8px;
                font-size: 14px;
                color: #6c757d;
            }

            .search-bookings::placeholder {
                color: #adb5bd;
            }

            .search-bookings:focus {
                outline: none;
                border-color: #667eea;
            }

            /* Calendar List */
            .calendar-list {
                max-height: 600px;
                overflow-y: auto;
                padding-right: 5px;
            }

            .calendar-list::-webkit-scrollbar {
                width: 6px;
            }

            .calendar-list::-webkit-scrollbar-track {
                background: #f1f1f1;
                border-radius: 10px;
            }

            .calendar-list::-webkit-scrollbar-thumb {
                background: #cbd5e0;
                border-radius: 10px;
            }

            .calendar-list::-webkit-scrollbar-thumb:hover {
                background: #a0aec0;
            }

            /* Month Header */
            .month-header {
                font-size: 11px;
                font-weight: 600;
                color: #6c757d;
                text-transform: uppercase;
                letter-spacing: 1px;
                margin: 20px 0 10px 0;
                padding-left: 5px;
            }

            .month-header:first-child {
                margin-top: 0;
            }

            /* Booking Day Card */
            .booking-day-card {
                margin-left: 5px;
                margin-right: 5px;
                display: block;
                padding: 0;
                background: #fff;
                border: 1px solid #e9ecef;
                border-radius: 12px;
                margin-bottom: 12px;
                transition: all 0.3s ease;
                cursor: pointer;
                overflow: hidden;
                box-shadow: 0px 1px 8px rgba(0, 0, 0, 0.3);
            }

            .booking-day-card:hover {
                border-color: #667eea;
                box-shadow: 0 4px 12px rgba(102, 126, 234, 0.5);
                transform: translateY(-2px);
            }

            /* Day Date Section */
            .day-date-section {
                flex-shrink: 0;
                text-align: center;
                width: 50px;
            }

            .day-name {
                font-size: 12px;
                color: #6c757d;
                text-transform: uppercase;
                margin-bottom: 4px;
            }

            .day-number {
                font-size: 24px;
                font-weight: 700;
                color: #212529;
                line-height: 1;
            }

            /* Booking Details */
            .booking-details {
                flex: 1;
            }

            .time-location {
                display: flex;
                align-items: center;
                gap: 8px;
                margin-bottom: 6px;
                font-size: 14px;
                color: #495057;
            }

            .time-location i.fa-clock {
                color: #6c757d;
                font-size: 13px;
            }

            .time-range {
                font-weight: 600;
            }

            .time-icon {
                margin-left: auto;
                font-size: 16px;
            }

            .day-icon {
                color: #ffa500;
            }

            .night-icon {
                color: #4a5568;
            }

            .location-info {
                display: flex;
                align-items: center;
                gap: 6px;
                font-size: 13px;
                color: #6c757d;
            }

            .location-info i {
                font-size: 12px;
            }

            /* Booking Actions */
            .booking-actions {
                flex-shrink: 0;
            }

            .add-booking-btn {
                width: 36px;
                height: 36px;
                border: 2px solid #e9ecef;
                background: #fff;
                border-radius: 8px;
                display: flex;
                align-items: center;
                justify-content: center;
                cursor: pointer;
                transition: all 0.3s ease;
            }

            .add-booking-btn:hover {
                background: #667eea;
                border-color: #667eea;
            }

            .add-booking-btn:hover i {
                color: #fff;
            }

            .add-booking-btn i {
                font-size: 14px;
                color: #6c757d;
                transition: color 0.3s ease;
            }

            /* See More Link */
            .see-more-link {
                text-align: right;
                padding: 15px 5px 5px 5px;
            }

            .see-more-link a {
                color: #667eea;
                font-size: 14px;
                font-weight: 600;
                text-decoration: none;
                display: inline-flex;
                align-items: center;
                gap: 6px;
                transition: all 0.3s ease;
            }

            .see-more-link a:hover {
                color: #5568d3;
                gap: 10px;
            }

            .see-more-link i {
                font-size: 12px;
            }

            /* Service Details Card (Right Column) */
            .service-details-card {
                background: #fff;
                border-radius: 20px;
                overflow: hidden;
                box-shadow: 0 10px 40px rgba(0, 0, 0, 0.08);
                height: 100%;
            }

            .service-image-wrapper {
                position: relative;
                height: 250px;
                overflow: hidden;
            }

            .service-detail-img {
                width: 100%;
                height: 100%;
                object-fit: cover;
                transition: transform 0.5s ease;
            }

            .service-details-card:hover .service-detail-img {
                transform: scale(1.05);
            }

            .service-badge {
                position: absolute;
                top: 20px;
                right: 20px;
                padding: 10px 20px;
                border-radius: 50px;
                font-size: 14px;
                font-weight: 600;
                display: flex;
                align-items: center;
                gap: 8px;
                backdrop-filter: blur(10px);
            }

            .turf-badge {
                background: rgba(40, 167, 69, 0.9);
                color: #fff;
            }

            .pool-badge {
                background: rgba(0, 123, 255, 0.9);
                color: #fff;
            }

            .service-info {
                padding: 30px;
            }

            .service-title {
                font-size: 24px;
                font-weight: 700;
                color: #212529;
                margin-bottom: 15px;
            }

            .service-description {
                font-size: 15px;
                color: #6c757d;
                line-height: 1.7;
                margin-bottom: 25px;
            }

            .service-features {
                margin-bottom: 25px;
            }

            .feature-item {
                display: flex;
                align-items: center;
                gap: 12px;
                padding: 10px 0;
                border-bottom: 1px solid #f0f0f0;
            }

            .feature-item:last-child {
                border-bottom: none;
            }

            .feature-item i {
                font-size: 18px;
                color: #28a745;
                flex-shrink: 0;
            }

            .feature-item span {
                font-size: 14px;
                color: #495057;
            }

            .service-pricing {
                background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
                border-radius: 12px;
                padding: 20px;
            }

            .pricing-item {
                display: flex;
                justify-content: space-between;
                align-items: center;
                padding: 10px 0;
            }

            .pricing-item:not(:last-child) {
                border-bottom: 1px solid #dee2e6;
            }

            .pricing-label {
                font-size: 14px;
                color: #6c757d;
                font-weight: 500;
            }

            .pricing-value {
                font-size: 18px;
                font-weight: 700;
                color: #212529;
            }

            /* ===== VISUAL SERVICE DETAILS CARD ===== */
            .service-details-card-visual {
                background: #fff;
                border-radius: 20px;
                overflow: hidden;
                box-shadow: 0 10px 40px rgba(0, 0, 0, 0.08);
            }

            .service-header {
                display: flex;
                justify-content: space-between;
                align-items: center;
                padding: 20px 25px;
                border-bottom: 1px solid #f0f0f0;
            }

            .service-dropdown-title {
                font-size: 18px;
                font-weight: 700;
                color: #212529;
                margin: 0;
                display: flex;
                align-items: center;
            }

            .service-dropdown-title i.fa-chevron-down {
                font-size: 14px;
                color: #6c757d;
            }

            .expand-btn {
                width: 36px;
                height: 36px;
                border: none;
                background: #f8f9fa;
                border-radius: 8px;
                display: flex;
                align-items: center;
                justify-content: center;
                cursor: pointer;
                transition: all 0.3s ease;
            }

            .expand-btn:hover {
                background: #e9ecef;
                transform: scale(1.05);
            }

            .expand-btn i {
                font-size: 14px;
                color: #495057;
            }

            /* Visual Container with Image */
            .service-visual-container {
                position: relative;
                height: 350px;
                background: #f8f9fa;
            }

            .service-visual-img {
                width: 100%;
                height: 100%;
                object-fit: cover;
            }

            /* Stat Overlays */
            .stat-overlay {
                position: absolute;
                background: rgba(255, 255, 255, 0.95);
                backdrop-filter: blur(10px);
                border-radius: 12px;
                padding: 12px 16px;
                display: flex;
                align-items: center;
                gap: 12px;
                box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
                min-width: 160px;
            }

            .stat-overlay i {
                font-size: 20px;
                color: #667eea;
                flex-shrink: 0;
            }

            .stat-top-right {
                top: 20px;
                right: 20px;
            }

            .stat-middle-right {
                top: 50%;
                right: 20px;
                transform: translateY(-50%);
            }

            .stat-bottom-right {
                bottom: 20px;
                right: 20px;
            }

            .stat-content {
                flex: 1;
            }

            .stat-label {
                font-size: 11px;
                color: #6c757d;
                text-transform: uppercase;
                letter-spacing: 0.5px;
                margin-bottom: 4px;
            }

            .stat-value {
                font-size: 22px;
                font-weight: 700;
                color: #212529;
                line-height: 1;
            }

            .stat-unit {
                font-size: 13px;
                font-weight: 500;
                color: #6c757d;
            }

            /* Bottom Info Card */
            .service-bottom-info {
                display: flex;
                align-items: center;
                gap: 15px;
                padding: 20px 25px;
                background: #fff;
            }

            .facility-avatar {
                width: 50px;
                height: 50px;
                border-radius: 50%;
                background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
                display: flex;
                align-items: center;
                justify-content: center;
                flex-shrink: 0;
            }

            .facility-avatar.pool-avatar {
                background: linear-gradient(135deg, #007bff 0%, #00c6ff 100%);
            }

            .facility-avatar i {
                font-size: 22px;
                color: #fff;
            }

            .facility-details {
                flex: 1;
            }

            .facility-name {
                font-size: 16px;
                font-weight: 700;
                color: #212529;
                margin: 0 0 4px 0;
            }

            .facility-type {
                font-size: 13px;
                color: #6c757d;
                margin: 0;
            }

            .facility-stats {
                display: flex;
                gap: 20px;
            }

            .facility-stat {
                text-align: center;
            }

            .facility-stat-value {
                font-size: 18px;
                font-weight: 700;
                color: #212529;
                line-height: 1;
                margin-bottom: 4px;
            }

            .facility-stat-label {
                font-size: 11px;
                color: #6c757d;
                text-transform: uppercase;
                letter-spacing: 0.5px;
            }

            /* Responsive Design for Booking Section */
            @media (max-width: 768px) {
                .booking-card {
                    padding: 25px;
                }

                .step-content {
                    padding-left: 0;
                }

                .step-header {
                    flex-direction: column;
                    align-items: flex-start;
                }

                .modern-tabs {
                    flex-wrap: nowrap !important;
                    overflow-x: auto;
                    /* justify-content: flex-start !important; removed to allow centering/filling */
                    -webkit-overflow-scrolling: touch;
                    gap: 10px !important;
                    /* Reduce gap */
                }

                .modern-tabs .nav-item {
                    flex: 1;
                    /* Make items grow equally */
                    min-width: 0;
                    /* Allow shrinking below content size if needed */
                }

                .modern-tabs::-webkit-scrollbar {
                    display: none;
                }

                .modern-tab-link {
                    /* min-width: 140px; removed specific min-width to allow flex */
                    padding: 12px 10px;
                    white-space: nowrap;
                    width: 100%;
                }

                .modern-tabs-wrapper .nav-item button {
                    box-shadow: 2px 4px 12px rgba(0, 0, 0, 0.25) !important;
                    width: 100%;
                }

                .tab-icon {
                    width: 24px;
                    height: 24px;
                    font-size: 14px;
                    margin-bottom: 0px;
                }

                /* Optional: Keep icon side-by-side on mobile to save height */
                .modern-tab-link {
                    flex-direction: row;
                    /* Ensure row layout inside button */
                    gap: 8px;
                    align-items: center;
                    justify-content: center;
                    display: flex;
                    /* Ensure flex layout */
                }

                .tab-content-text {
                    text-align: left;
                }

                .tab-title {
                    font-size: 14px;
                    margin-bottom: 0;
                    line-height: 1.2;
                }

                .tab-subtitle {
                    display: none;
                }

                .slots-grid {
                    grid-template-columns: repeat(auto-fill, minmax(100px, 1fr));
                }

                /* Two-column layout responsive */
                .booking-form-card {
                    padding: 20px;
                    margin-bottom: 20px;
                }

                .service-image-wrapper {
                    height: 200px;
                }

                .service-info {
                    padding: 20px;
                }

                .service-title {
                    font-size: 20px;
                }

                .slots-grid-compact {
                    grid-template-columns: repeat(auto-fill, minmax(90px, 1fr));
                    max-height: 250px;
                }

                /* Visual service card responsive */
                .service-visual-container {
                    height: 250px;
                }

                .stat-overlay {
                    min-width: 140px;
                    padding: 10px 12px;
                }

                .stat-value {
                    font-size: 18px;
                }

                .stat-overlay i {
                    font-size: 16px;
                }

                .facility-stats {
                    flex-direction: column;
                    gap: 10px;
                }

                .service-header {
                    padding: 15px 20px;
                }

                .service-dropdown-title {
                    font-size: 16px;
                }
            }

            /* Toggle Icon Circle Fix */
            .toggle-icon {
                width: 36px;
                height: 36px;
                padding: 0;
                display: flex;
                align-items: center;
                justify-content: center;
                border-radius: 50% !important;
                border: 1px solid #e9ecef;
            }

            .toggle-icon i {
                font-size: 14px;
                color: #6c757d;
            }
        </style>
    @endpush


    @if(!isset($rescheduleBooking))
        <div class="hero-area-enhanced position-relative overflow-hidden">
            <!-- Animated Background Gradient -->
            <div class="hero-gradient-bg"></div>

            <!-- Floating Animated Shapes -->
            <div class="floating-shapes">
                <div class="shape shape-1"></div>
                <div class="shape shape-2"></div>
                <div class="shape shape-3"></div>
                <div class="shape shape-4"></div>
            </div>

            <!-- Background Image Slideshow -->
            <div class="hero-slideshow">
                <img src="{{ asset('user/assets/img/hero/hero_turf_premium_real.png') }}" alt="Premium Turf Field"
                    class="hero-slide-img active">
                <img src="{{ asset('user/assets/img/hero/hero_pool_premium_real.png') }}" alt="Luxury Swimming Pool"
                    class="hero-slide-img">
                <img src="{{ asset('user/assets/img/hero/hero_turf_night_premium.png') }}" alt="Night Turf Match"
                    class="hero-slide-img">
                <img src="{{ asset('user/assets/img/hero/hero_pool_outdoor_premium.png') }}" alt="Outdoor Luxury Pool"
                    class="hero-slide-img">
            </div>

            <!-- Dark Gradient Overlay -->
            <div class="hero-overlay-dark"></div>

            <!-- Floating Animated Shapes (Optional, keep for subtle effect behind text if needed, or remove) -->
            <div class="floating-shapes" style="z-index: 3;">
                <div class="shape shape-1"></div>
                <div class="shape shape-2"></div>
            </div>

            <div class="container-fluid py-5 position-relative" style="z-index: 10;">
                <div class="row min-vh-75 align-items-center">
                    <div class="col-lg-8 col-xl-7">
                        <div class="hero-content-enhanced text-center text-lg-start px-3 px-lg-5">
                            <!-- Premium Badge -->
                            <div class="hero-badge mb-4" data-aos="fade-down">
                                <span class="badge-icon">⚡</span>
                                <span class="badge-text">Elevate Your Game. Relax in Style.</span>
                            </div>

                            <!-- Main Heading with Gradient -->
                            <h1 class="hero-title mb-4" data-aos="fade-up" data-aos-delay="100">
                                Premium <span class="gradient-text">Turf & Pool</span> Booking Experience
                            </h1>

                            <!-- Description -->
                            <p class="hero-description mb-5" data-aos="fade-up" data-aos-delay="200">
                                Welcome to our premier booking platform. From thrilling matches on the turf to peaceful dips
                                in the pool,
                                <strong>enjoy every moment your way</strong> with seamless booking and world-class
                                facilities.
                            </p>

                            <!-- CTA Buttons -->
                            <div class="hero-cta-buttons d-flex flex-wrap gap-3 justify-content-center justify-content-lg-start mb-4"
                                data-aos="fade-up" data-aos-delay="300">
                                <a href="#tab_turf" class="btn-hero btn-hero-primary"
                                    onclick="document.querySelector('[data-bs-target=\'#tab_turf\']').click()">
                                    <i class="fas fa-futbol me-2"></i>
                                    Book Turf Now
                                </a>
                                <a href="#tab_pool" class="btn-hero btn-hero-secondary"
                                    onclick="document.querySelector('[data-bs-target=\'#tab_pool\']').click()">
                                    <i class="fas fa-swimmer me-2"></i>
                                    Book Pool Now
                                </a>
                            </div>

                            <!-- Stats/Features -->
                            <div class="hero-stats d-flex flex-wrap gap-4 justify-content-center justify-content-lg-start"
                                data-aos="fade-up" data-aos-delay="400">
                                <div class="stat-item">
                                    <div class="stat-icon">
                                        <i class="fas fa-check-circle"></i>
                                    </div>
                                    <div class="stat-content">
                                        <h4 class="stat-number">100%</h4>
                                        <p class="stat-label">Verified</p>
                                    </div>
                                </div>
                                <div class="stat-item">
                                    <div class="stat-icon">
                                        <i class="fas fa-clock"></i>
                                    </div>
                                    <div class="stat-content">
                                        <h4 class="stat-number">24/7</h4>
                                        <p class="stat-label">Available</p>
                                    </div>
                                </div>
                                <div class="stat-item">
                                    <div class="stat-icon">
                                        <i class="fas fa-star"></i>
                                    </div>
                                    <div class="stat-content">
                                        <h4 class="stat-number">5★</h4>
                                        <p class="stat-label">Rated</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
    @endif
    </div>


    <!-- Modern Booking Section -->
    <div class="booking-section-modern position-relative py-5">
        <div class="container-fluid">
            <!-- Section Header -->
            <div class="text-center mb-5" data-aos="fade-up">
                <span class="section-badge">Quick & Easy Booking</span>
                <h2 class="section-title mt-3 mb-3">Reserve Your Spot in 3 Simple Steps</h2>
                <p class="section-subtitle">Choose your service, pick a date, and select your preferred time slot</p>
            </div>

            <!-- Modern Tab Navigation -->
            <div class="modern-tabs-wrapper mb-4" data-aos="fade-up" data-aos-delay="100">
                <ul class="nav nav-tabs modern-tabs border-0 justify-content-center py-3" id="serviceTabs"
                    role="tablist">
                    @php
                        $isReschedule = isset($rescheduleBooking);
                        $rescheduleService = $isReschedule ? strtolower($rescheduleBooking->bookingFor->service ?? '') : '';
                        $showTurf = !$isReschedule || str_contains($rescheduleService, 'turf');
                        $showPool = !$isReschedule || str_contains($rescheduleService, 'pool');
                    @endphp

                    @if($showTurf)
                        <li class="nav-item p-2" role="presentation">
                            <button
                                class="nav-link modern-tab-link py-3 {{ $showTurf && !$showPool ? 'active' : ($showTurf ? 'active' : '') }}"
                                data-bs-toggle="tab" data-bs-target="#tab_turf" type="button" role="tab">
                                <div class="tab-icon turf-icon">
                                    <i class="fas fa-futbol"></i>
                                </div>
                                <div class="tab-content-text">
                                    <h5 class="tab-title">Turf Sport</h5>
                                    @if($isReschedule) <span class="badge bg-warning text-dark ms-2">Rescheduling</span>
                                    @else <p class="tab-subtitle">Book your game</p> @endif
                                </div>
                            </button>
                        </li>
                    @endif

                    @if($showPool)
                        <li class="nav-item p-2" role="presentation">
                            <button class="nav-link modern-tab-link py-3 {{ $showPool && !$showTurf ? 'active' : '' }}"
                                data-bs-toggle="tab" data-bs-target="#tab_pool" type="button" role="tab">
                                <div class="tab-icon pool-icon">
                                    <i class="fas fa-swimmer"></i>
                                </div>
                                <div class="tab-content-text">
                                    <h5 class="tab-title">Swimming Pool</h5>
                                    @if($isReschedule) <span class="badge bg-warning text-dark ms-2">Rescheduling</span>
                                    @else <p class="tab-subtitle">Dive into relaxation</p> @endif
                                </div>
                            </button>
                        </li>
                    @endif
                </ul>
            </div>

            @if(isset($rescheduleBooking))
                <div class="container mb-4">
                    <div class="alert alert-warning border-0 shadow-sm d-flex align-items-center" role="alert">
                        <i class="fas fa-sync-alt fa-2x me-3 text-warning"></i>
                        <div>
                            <h5 class="alert-heading fw-bold mb-1">Rescheduling Booking</h5>
                            <p class="mb-0">Select your new <strong>consecutive time slot(s)</strong> to replace your previous booking.</p>
                        </div>
                        <a href="{{ route('my-booking.show') }}"
                            class="btn btn-outline-dark ms-auto btn-sm rounded-pill">Cancel Reschedule</a>
                    </div>
                </div>
            @endif

            <!-- Tab Content with Two-Column Layout -->
            <div class="tab-content modern-tab-content" data-aos="fade-up" data-aos-delay="200">
                <!-- Turf Booking Tab -->
                <div class="tab-pane fade show active" id="tab_turf" role="tabpanel">
                    <div class="row g-4">
                        <!-- Left Column: 7-Day Calendar View -->
                        <div class="col-lg-8">
                            <form id="turfForm" class="modern-booking-form">
                                @csrf
                                <input type="hidden" name="service" value="turf">
                                <input type="hidden" name="booking_for_id" value="1">
                                <input type="hidden" name="hours" id="selectedHoursTurf">

                                <input type="hidden" name="date" id="selectedDateTurf">

                                <div class="booking-form-card">
                                    <div class="booking-header">
                                        <h4 class="booking-form-title">
                                            <i class="fas fa-calendar-alt me-2"></i>
                                            Available Bookings
                                        </h4>
                                        <!-- <input type="text" class="search-bookings" placeholder="Enter your search request..."> -->
                                    </div>

                                    <!-- 7-Day Calendar List -->
                                    <div class="calendar-list mb-3">
                                        @php
                                            $startDate = now();
                                        @endphp

                                        @for ($i = 0; $i < 7; $i++)
                                            @php
                                                $date = $startDate->copy()->addDays($i);
                                                $isToday = $i === 0;
                                                $formattedDate = $date->format('Y-m-d');
                                                $dayName = $date->format('D');
                                                $dayNumber = $date->format('d');
                                                $fullDate = $date->format('F Y');
                                            @endphp

                                            <!-- Day Card -->
                                            <div class="booking-day-card mt-3" data-day-index="{{ $i }}"
                                                data-date="{{ $formattedDate }}" data-service="turf">
                                                <!-- Clickable Header -->
                                                <div class="col day-card-header d-flex justify-content-between align-items-center p-3"
                                                    style="cursor: pointer;">
                                                    <div class="day-date-section">
                                                        <div class="day-name">{{ $dayName }}</div>
                                                        <div class="day-number">{{ $dayNumber }}</div>
                                                    </div>

                                                    <div class="day-info text-start flex-grow-1 ms-4">
                                                        <span class="text-muted fs-7">{{ $fullDate }}</span>
                                                        <div class="d-flex align-items-center mt-1">
                                                            <i class="far fa-clock me-2 text-primary"></i>
                                                            <span class="fw-bold text-dark fs-6">View Available Slots</span>
                                                        </div>
                                                    </div>

                                                    <div class="booking-actions">
                                                        <button type="button"
                                                            class="btn btn-sm btn-light rounded-circle toggle-icon transition">
                                                            <i class="fas fa-chevron-down"></i>
                                                        </button>
                                                    </div>
                                                </div>

                                                <!-- Slots Container (Accordion Body) -->
                                                <div class="col day-slots-container p-3 border-top bg-light/50"
                                                    id="slots_container_{{ $i }}" style="display: none;">
                                                    <!-- <div class="slots-header mb-3">
                                                                                                                                                                                                                                                                                                                                                                                                                    <small class="text-muted">Select your preferred time slots:</small>
                                                                                                                                                                                                                                                                                                                                                                                                                </div> -->
                                                    <div class="slots-grid-compact" id="slots_grid_{{ $i }}">
                                                        <!-- Slots will be loaded here via AJAX -->
                                                    </div>
                                                </div>
                                            </div>
                                        @endfor
                                    </div>

                                    <!-- Sticky Checkout Footer -->
                                    <div class="calendar-footer py-3 border-top sticky-bottom bg-white"
                                        style="position: sticky; bottom: 0; z-index: 10;">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <div class="selection-info">
                                                <span class="text-muted fs-5">Selected slots:</span>
                                                <span class="fw-bold fs-5 text-dark ms-1 count-display-turf">0</span>
                                            </div>
                                            <button type="submit"
                                                class="btn rounded-pill text-white border-0 shadow-lg p-3 bg-body p-3"
                                                style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                                                <i class="fas fa-check-circle me-2"></i> Book Selected Slots
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>

                        <!-- Right Column: Service Details -->
                        <div class="col-lg-4">
                            <div class="service-details-card-visual">
                                <!-- Header with Title -->
                                <div class="service-header">
                                    <h3 class="service-dropdown-title">
                                        <i class="fas fa-futbol me-2"></i>
                                        Premium Turf
                                        <i class="fas fa-chevron-down ms-2"></i>
                                    </h3>
                                    <button class="expand-btn">
                                        <i class="fas fa-expand-alt"></i>
                                    </button>
                                </div>

                                <!-- Large Visual Image with Stats Overlay -->
                                <div class="service-visual-container">
                                    <img src="{{ asset('user/assets/img/hero/hero-banner-gradient.png') }}"
                                        alt="Turf Field" class="service-visual-img">

                                    <!-- Stats Overlays -->
                                    <div class="stat-overlay stat-top-right">
                                        <i class="fas fa-ruler-combined"></i>
                                        <div class="stat-content">
                                            <div class="stat-label">Field size</div>
                                            <div class="stat-value">100x60 <span class="stat-unit">meters</span></div>
                                        </div>
                                    </div>

                                    <div class="stat-overlay stat-middle-right">
                                        <i class="fas fa-users"></i>
                                        <div class="stat-content">
                                            <div class="stat-label">Capacity</div>
                                            <div class="stat-value">22 <span class="stat-unit">players</span></div>
                                        </div>
                                    </div>

                                    <div class="stat-overlay stat-bottom-right">
                                        <i class="fas fa-calendar-check"></i>
                                        <div class="stat-content">
                                            <div class="stat-label">Availability</div>
                                            <div class="stat-value">95<span class="stat-unit">%</span></div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Bottom Info Card -->
                                <div class="service-bottom-info">
                                    <div class="facility-avatar">
                                        <i class="fas fa-building"></i>
                                    </div>
                                    <div class="facility-details">
                                        <h4 class="facility-name">FIFA Standard Turf</h4>
                                        <p class="facility-type">
                                            <i class="fas fa-map-marker-alt me-1"></i>
                                            Professional grade facility
                                        </p>
                                    </div>
                                    <div class="facility-stats">
                                        <div class="facility-stat">
                                            <div class="facility-stat-value">₹500</div>
                                            <div class="facility-stat-label">Per Hour</div>
                                        </div>
                                        <div class="facility-stat">
                                            <div class="facility-stat-value">4.8★</div>
                                            <div class="facility-stat-label">Rating</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Pool Booking Tab -->
                <div class="tab-pane fade" id="tab_pool" role="tabpanel">
                    <div class="row g-4">
                        <!-- Left Column: Booking Form -->
                        <div class="col-lg-8">
                            <form id="poolForm" class="modern-booking-form">
                                @csrf
                                <input type="hidden" name="service" value="pool">
                                <input type="hidden" name="booking_for_id" value="2">
                                <input type="hidden" name="hours" id="selectedHoursPool">
                                <input type="hidden" name="date" id="selectedDatePool">

                                <div class="booking-form-card">
                                    <div class="booking-header">
                                        <h4 class="booking-form-title">
                                            <i class="fas fa-calendar-alt me-2"></i>
                                            Available Bookings
                                        </h4>
                                        <!-- <input type="text" class="search-bookings" placeholder="Enter your search request..."> -->
                                    </div>

                                    <!-- 7-Day Dynamic Calendar List -->
                                    <div class="calendar-list">
                                        @php
                                            $startDate = now();
                                        @endphp

                                        @for ($i = 0; $i < 7; $i++)
                                            @php
                                                $date = $startDate->copy()->addDays($i);
                                                $isToday = $i === 0;
                                                $formattedDate = $date->format('Y-m-d');
                                                $dayName = $date->format('D');
                                                $dayNumber = $date->format('d');
                                                $fullDate = $date->format('F Y');
                                            @endphp

                                            <!-- Day Card -->
                                            <div class="booking-day-card mt-3" data-day-index="{{ $i }}"
                                                data-date="{{ $formattedDate }}" data-service="pool">
                                                <!-- Clickable Header -->
                                                <div class="col day-card-header d-flex justify-content-between align-items-center p-3"
                                                    style="cursor: pointer;">
                                                    <div class="day-date-section">
                                                        <div class="day-name">{{ $dayName }}</div>
                                                        <div class="day-number">{{ $dayNumber }}</div>
                                                    </div>

                                                    <div class="day-info text-start flex-grow-1 ms-4">
                                                        <span class="text-muted fs-7">{{ $fullDate }}</span>
                                                        <div class="d-flex align-items-center mt-1">
                                                            <i class="far fa-clock me-2 text-primary"></i>
                                                            <span class="fw-bold text-dark fs-6">View Available Slots</span>
                                                        </div>
                                                    </div>

                                                    <div class="booking-actions">
                                                        <button type="button"
                                                            class="btn btn-sm btn-light rounded-circle toggle-icon transition">
                                                            <i class="fas fa-chevron-down"></i>
                                                        </button>
                                                    </div>
                                                </div>

                                                <!-- Slots Container (Accordion Body) -->
                                                <div class="col day-slots-container p-3 border-top bg-light/50"
                                                    id="pool_slots_container_{{ $i }}" style="display: none;">
                                                    <div class="slots-grid-compact" id="pool_slots_grid_{{ $i }}">
                                                        <!-- Slots will be loaded here via AJAX -->
                                                    </div>
                                                </div>
                                            </div>
                                        @endfor
                                    </div>

                                    <!-- Sticky Checkout Footer -->
                                    <div class="calendar-footer mt-3 pt-3 border-top sticky-bottom bg-white"
                                        style="position: sticky; bottom: 0; z-index: 10;">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <div class="selection-info">
                                                <span class="text-muted fs-5">Selected slots:</span>
                                                <span class="fw-bold fs-5 text-dark ms-1 count-display-pool">0</span>
                                            </div>
                                            <button type="submit"
                                                class="btn rounded-pill text-white border-0 shadow-lg p-3 bg-body p-3"
                                                style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                                                <i class="fas fa-check-circle me-2"></i> Book Selected Slots
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>

                        <!-- Right Column: Service Details -->
                        <div class="col-lg-4">
                            <div class="service-details-card-visual">
                                <!-- Header with Title -->
                                <div class="service-header">
                                    <h3 class="service-dropdown-title">
                                        <i class="fas fa-swimmer me-2"></i>
                                        Olympic Pool
                                        <i class="fas fa-chevron-down ms-2"></i>
                                    </h3>
                                    <button class="expand-btn">
                                        <i class="fas fa-expand-alt"></i>
                                    </button>
                                </div>

                                <!-- Large Visual Image with Stats Overlay -->
                                <div class="service-visual-container">
                                    <img src="{{ asset('user/assets/img/hero/hero-banner-modern.png') }}"
                                        alt="Swimming Pool" class="service-visual-img">

                                    <!-- Stats Overlays -->
                                    <div class="stat-overlay stat-top-right">
                                        <i class="fas fa-swimming-pool"></i>
                                        <div class="stat-content">
                                            <div class="stat-label">Pool length</div>
                                            <div class="stat-value">50 <span class="stat-unit">meters</span></div>
                                        </div>
                                    </div>

                                    <div class="stat-overlay stat-middle-right">
                                        <i class="fas fa-temperature-high"></i>
                                        <div class="stat-content">
                                            <div class="stat-label">Water temp</div>
                                            <div class="stat-value">28 <span class="stat-unit">°C</span></div>
                                        </div>
                                    </div>

                                    <div class="stat-overlay stat-bottom-right">
                                        <i class="fas fa-water"></i>
                                        <div class="stat-content">
                                            <div class="stat-label">Depth range</div>
                                            <div class="stat-value">1.2-2m <span class="stat-unit"></span></div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Bottom Info Card -->
                                <div class="service-bottom-info">
                                    <div class="facility-avatar pool-avatar">
                                        <i class="fas fa-water"></i>
                                    </div>
                                    <div class="facility-details">
                                        <h4 class="facility-name">Olympic Swimming Pool</h4>
                                        <p class="facility-type">
                                            <i class="fas fa-map-marker-alt me-1"></i>
                                            Heated & filtered water
                                        </p>
                                    </div>
                                    <div class="facility-stats">
                                        <div class="facility-stat">
                                            <div class="facility-stat-value">₹300</div>
                                            <div class="facility-stat-label">Per Hour</div>
                                        </div>
                                        <div class="facility-stat">
                                            <div class="facility-stat-value">4.9★</div>
                                            <div class="facility-stat-label">Rating</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Pool Booking Tab -->
                <div class="tab-pane fade" id="tab_pool" role="tabpanel">
                    <div class="row g-4">
                        <!-- Left Column: Booking Form -->
                        <div class="col-lg-6">
                            <form id="poolForm" class="modern-booking-form">
                                @csrf
                                <input type="hidden" name="service" value="pool">
                                <input type="hidden" name="booking_for_id" value="2">
                                <input type="hidden" name="hours" id="poolSelectedHours">

                                <div class="booking-form-card">
                                    <h4 class="booking-form-title">
                                        <i class="fas fa-calendar-check me-2"></i>
                                        Book Your Slot
                                    </h4>

                                    <!-- Date Selection -->
                                    <div class="form-group-modern mb-4">
                                        <label class="form-label-modern">
                                            <i class="far fa-calendar-alt me-2"></i>
                                            Select Date
                                        </label>
                                        <div class="date-input-wrapper">
                                            <input type="text" id="poolDate" name="date"
                                                class="datepicker-input modern-input"
                                                placeholder="Choose your preferred date" min="{{ date('Y-m-d') }}"
                                                autocomplete="off">
                                        </div>
                                        <span class="text-danger error-text date_err"></span>
                                    </div>

                                    <!-- Time Slot Selection -->
                                    <div class="form-group-modern">
                                        <label class="form-label-modern">
                                            <i class="far fa-clock me-2"></i>
                                            Available Time Slots
                                        </label>
                                        <div id="poolHourOptions" class="slots-grid-compact">
                                            <div class="slots-placeholder-compact">
                                                <i class="fas fa-info-circle"></i>
                                                <p>Select a date to view available slots</p>
                                            </div>
                                        </div>
                                        <span class="text-danger hours_err d-block mt-3"></span>
                                    </div>

                                    <!-- Submit Button -->
                                    <button type="submit" class="btn-modern btn-modern-primary w-100 mt-4">
                                        <i class="fas fa-check-circle me-2"></i>
                                        Confirm Pool Booking
                                    </button>
                                </div>
                            </form>
                        </div>

                        <!-- Right Column: Service Details -->
                        <div class="col-lg-6">
                            <div class="service-details-card">
                                <div class="service-image-wrapper">
                                    <img src="{{ asset('user/assets/img/hero/hero-banner-modern.png') }}"
                                        alt="Swimming Pool" class="service-detail-img">
                                    <div class="service-badge pool-badge">
                                        <i class="fas fa-swimmer"></i>
                                        Swimming Pool
                                    </div>
                                </div>

                                <div class="service-info">
                                    <h3 class="service-title">Luxury Swimming Pool</h3>
                                    <p class="service-description">
                                        Dive into our Olympic-sized swimming pool with crystal-clear water,
                                        perfect for lap swimming, training, or leisure activities.
                                    </p>

                                    <div class="service-features">
                                        <div class="feature-item">
                                            <i class="fas fa-check-circle"></i>
                                            <span>Olympic-sized 50m pool</span>
                                        </div>
                                        <div class="feature-item">
                                            <i class="fas fa-check-circle"></i>
                                            <span>Heated water year-round</span>
                                        </div>
                                        <div class="feature-item">
                                            <i class="fas fa-check-circle"></i>
                                            <span>Professional lifeguards on duty</span>
                                        </div>
                                        <div class="feature-item">
                                            <i class="fas fa-check-circle"></i>
                                            <span>Lockers & changing facilities</span>
                                        </div>
                                    </div>

                                    <div class="service-pricing">
                                        <div class="pricing-item">
                                            <span class="pricing-label">Hourly Rate</span>
                                            <span class="pricing-value">₹300/hour</span>
                                        </div>
                                        <div class="pricing-item">
                                            <span class="pricing-label">Full Day Pass</span>
                                            <span class="pricing-value">₹1500/day</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>



    <div class="container-fluid style-two pt-120 pb-90">
        <h2 class="section-title style-three text-center mb-35 reveal-text">How It Works</h2>
        <div class="row justify-content-center">
            <div class="col-xxl-3 col-xl-4 col-lg-4 col-md-6 col-sm-6">
                <div class="feature-card style-one mb-30 transition text-center" data-cue="slideInLeft">
                    <span class="feature-icon d-inline-block mb-3">
                        <img src="{{ asset('user/assets/img/icons/calendar.svg') }}" alt="Search"
                            style="width: 60px; height: 60px;">
                    </span>
                    <h3 class="fs-22">1. Search & Select</h3>
                    <p class="mb-0">Choose your preferred sport (Turf or Pool) and select a convenient date.</p>
                </div>
            </div>
            <div class="col-xxl-3 col-xl-4 col-lg-4 col-md-6 col-sm-6">
                <div class="feature-card style-one mb-30 transition text-center" data-cue="slideInLeft">
                    <span class="feature-icon d-inline-block mb-3">
                        <img src="{{ asset('user/assets/img/icons/check-orange-large.svg') }}" alt="Book"
                            style="width: 60px; height: 60px;">
                    </span>
                    <h3 class="fs-22">2. Book Your Slot</h3>
                    <p class="mb-0">Pick your available time slot and confirm your booking instantly.</p>
                </div>
            </div>
            <div class="col-xxl-3 col-xl-4 col-lg-4 col-md-6 col-sm-6">
                <div class="feature-card style-one mb-30 transition text-center" data-cue="slideInLeft">
                    <span class="feature-icon d-inline-block mb-3">
                        <img src="{{ asset('user/assets/img/icons/star.svg') }}" alt="Play"
                            style="width: 60px; height: 60px;">
                    </span>
                    <h3 class="fs-22">3. Play & Enjoy</h3>
                    <p class="mb-0">Show up at the venue and enjoy your game with friends and family.</p>
                </div>
            </div>
        </div>
    </div>


    <!-- Slot Selection Alert -->
    <div id="slotAlert" class="alert alert-danger alert-dismissible fade d-none" role="alert"
        style="position: fixed; top: 80px; left: 50%; transform: translateX(-50%); z-index: 9999; min-width: 350px; max-width: 90%; box-shadow: 0 4px 20px rgba(0,0,0,0.2); border-radius: 12px;">
        <div class="d-flex align-items-center">
            <i class="fas fa-exclamation-triangle me-3" style="font-size: 24px;"></i>
            <div>
                <strong>Invalid Selection!</strong><br>
                <span class="small">Please select consecutive time slots only. You cannot skip slots in between.</span>
            </div>
        </div>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>


    @push('scripts')
        <script>
            // Hero Banner Slideshow with Fade Effect
            $(document).ready(function () {
                const slides = $('.hero-slide-img');
                let currentSlide = 0;

                // Only run if there are multiple slides
                if (slides.length > 1) {
                    setInterval(function () {
                        // Remove active class from current slide
                        $(slides[currentSlide]).removeClass('active');

                        // Move to next slide
                        currentSlide = (currentSlide + 1) % slides.length;

                        // Add active class to new slide
                        $(slides[currentSlide]).addClass('active');
                    }, 5000); // Change image every 5 seconds
                }
            });

            // Helper functions for displaying server-side errors
            function resetErrors(form) {
                $(form).find('.error-text').text('');
            }

            function printErrMsg(errors) {
                $.each(errors, function (key, value) {
                    // For nested keys like hours.0
                    $(`.${key.replace('.', '_')}_err`).text(value[0]);
                });
            }

            $(document).ready(function () {

                function loadAvailableHours(service, date, hourContainerId, hiddenFieldId) {
                    if (!date) return;

                    const $hourContainer = $(hourContainerId);
                    const $hiddenField = $(hiddenFieldId);

                    $hourContainer.html('<div class="d-flex justify-content-center py-4"><div class="spinner-border text-primary" role="status"><span class="visually-hidden">Loading...</span></div></div>');
                    $hiddenField.val('');

                    $.ajax({
                        url: '{{ route('get-slots') }}',
                        type: 'GET',
                        data: {
                            service: service,
                            date: date
                        },
                        success: function (response) {
                            if (response.all_hours && response.all_hours.length > 0) {
                                let html = '';

                                response.all_hours.forEach((hour, index) => {
                                    const isAvailable = response.hours.includes(hour);

                                    let dateObj = new Date(`1970-01-01T${hour}`);
                                    let displayHour = dateObj.getHours();
                                    let period = displayHour >= 12 ? 'PM' : 'AM';

                                    // Icon based on time of day
                                    let icon = (displayHour >= 6 && displayHour < 18)
                                        ? '<i class="fas fa-sun text-warning"></i>'
                                        : '<i class="fas fa-moon"></i>';

                                    displayHour = displayHour % 12 || 12;
                                    let formatted = `${displayHour} ${period}`;

                                    // Unique ID for the checkbox input
                                    let inputId = `${service}_${hourContainerId.replace('#', '')}_${index}`;
                                    let cardClass = isAvailable ? 'slot-card' : 'slot-card disabled';

                                    html += `
                                                                                                                                                                                                                                                                                                                                                                                                    <label class="${cardClass}" for="${inputId}">
                                                                                                                                                                                                                                                                                                                                                                                                        <input class="hour-checkbox" 
                                                                                                                                                                                                                                                                                                                                                                                                            type="checkbox" 
                                                                                                                                                                                                                                                                                                                                                                                                            id="${inputId}" 
                                                                                                                                                                                                                                                                                                                                                                                                            value="${hour}"
                                                                                                                                                                                                                                                                                                                                                                                                            ${!isAvailable ? 'disabled' : ''}>
                                                                                                                                                                                                                                                                                                                                                                                                        ${icon}
                                                                                                                                                                                                                                                                                                                                                                                                        <span class="ms-2">${formatted}</span>
                                                                                                                                                                                                                                                                                                                                                                                                    </label>`;
                                });

                                $hourContainer.html(html);

                                // Event listener for slot selection with consecutive validation
                                $hourContainer.find('.hour-checkbox').on('change', function () {
                                    const $this = $(this);
                                    const $card = $this.closest('.slot-card');
                                    const currentHour = $this.val();

                                    // Get all available (non-disabled) checkboxes in order
                                    const $allCheckboxes = $hourContainer.find('.hour-checkbox:not(:disabled)');
                                    const allHours = $allCheckboxes.map(function () { return $(this).val(); }).get();
                                    const currentIndex = allHours.indexOf(currentHour);

                                    // If checking a new slot
                                    if ($this.is(':checked')) {
                                        // Get previously selected slots (excluding current one since we want to validate against existing selection)
                                        const previouslySelected = $hourContainer.find('.hour-checkbox:checked').not($this)
                                            .map(function () { return $(this).val(); }).get();

                                        // If there are already selected slots, check if this one is consecutive
                                        if (previouslySelected.length > 0) {
                                            // Get indices of previously selected slots
                                            const previousIndices = previouslySelected
                                                .map(h => allHours.indexOf(h))
                                                .filter(i => i !== -1)
                                                .sort((a, b) => a - b);

                                            const minSelected = Math.min(...previousIndices);
                                            const maxSelected = Math.max(...previousIndices);

                                            // Current must be exactly one before min or one after max
                                            const isConsecutive = (currentIndex === minSelected - 1) || (currentIndex === maxSelected + 1);

                                            if (!isConsecutive) {
                                                // Not consecutive, uncheck and show alert
                                                $this.prop('checked', false);
                                                $card.removeClass('selected active');
                                                const $alert = $('#slotAlert');
                                                $alert.removeClass('d-none').addClass('show');

                                                // auto-hide after 3 sec (optional)
                                                setTimeout(() => {
                                                    $alert.removeClass('show').addClass('d-none');
                                                }, 3000);

                                                return;
                                                // Show toast/alert
                                                // alert('Please select consecutive time slots only. You cannot skip slots in between.');
                                                // return;
                                            }
                                        }

                                        $card.addClass('selected active');
                                    } else {
                                        // When unchecking, ensure remaining slots are still consecutive
                                        const remainingHours = $hourContainer.find('.hour-checkbox:checked')
                                            .map(function () { return $(this).val(); }).get();

                                        if (remainingHours.length > 1) {
                                            const remainingIndices = remainingHours
                                                .map(h => allHours.indexOf(h))
                                                .filter(i => i !== -1)
                                                .sort((a, b) => a - b);

                                            // Check if remaining are consecutive
                                            let isStillConsecutive = true;
                                            for (let i = 1; i < remainingIndices.length; i++) {
                                                if (remainingIndices[i] - remainingIndices[i - 1] !== 1) {
                                                    isStillConsecutive = false;
                                                    break;
                                                }
                                            }

                                            if (!isStillConsecutive) {
                                                // Can't uncheck middle slots
                                                $this.prop('checked', true);
                                                $card.addClass('selected active');

                                                const $alert = $('#slotAlert');
                                                $alert.find('strong').text('Cannot Deselect!');
                                                $alert.find('.small').text('You can only deselect slots from the beginning or end of your selection.');
                                                $alert.removeClass('d-none').addClass('show');

                                                setTimeout(() => {
                                                    $alert.removeClass('show').addClass('d-none');
                                                    // Reset text
                                                    $alert.find('strong').text('Invalid Selection!');
                                                    $alert.find('.small').text('Please select consecutive time slots only. You cannot skip slots in between.');
                                                }, 3000);

                                                return;
                                            }
                                        }

                                        $card.removeClass('selected active');
                                    }

                                    const selected = $hourContainer.find('.hour-checkbox:checked')
                                        .map(function () {
                                            return $(this).val();
                                        })
                                        .get();

                                    $hiddenField.val(selected.join(','));

                                    // Update count display
                                    $(`.count-display-${service}`).text(selected.length);
                                });
                            } else {
                                $hourContainer.html(
                                    '<div class="alert alert-danger w-100 mb-0" style="grid-column: 1 / -1;">No slots defined for this day.</div>');
                                $hiddenField.val('');
                            }
                        },
                        error: function () {
                            $hourContainer.html(
                                '<div class="alert alert-danger w-100 mb-0" style="grid-column: 1 / -1;">Error fetching slots. Try again.</div>');
                            $hiddenField.val('');
                        }
                    });
                }

                // Consolidated Calendar Interaction Handler
                $(document).on('click', '.booking-day-card .day-card-header', function () {
                    const card = $(this).closest('.booking-day-card');
                    const service = card.data('service'); // 'turf' or 'pool'
                    const date = card.data('date');
                    const index = card.data('day-index');
                    const slotSection = card.find('.day-slots-container');
                    const icon = $(this).find('.toggle-icon');

                    // Determine IDs based on service
                    let containerId, dateInputId, hoursInputId;
                    if (service === 'turf') {
                        containerId = `#slots_grid_${index}`;
                        dateInputId = '#selectedDateTurf';
                        hoursInputId = '#selectedHoursTurf';
                    } else if (service === 'pool') {
                        containerId = `#pool_slots_grid_${index}`;
                        dateInputId = '#selectedDatePool';
                        hoursInputId = '#selectedHoursPool';
                    }

                    // Scope selection to the specific tab
                    const tabPane = card.closest('.tab-pane');
                    const allCards = tabPane.find('.booking-day-card');
                    const allSlotSections = tabPane.find('.day-slots-container');
                    const allIcons = tabPane.find('.toggle-icon');

                    // If clicking the already active card, toggle it off
                    if (card.hasClass('active-day')) {
                        card.removeClass('active-day border border-2 border-primary shadow');
                        slotSection.slideUp();
                        icon.html('<i class="fas fa-chevron-down"></i>');
                        $(dateInputId).val(''); // Clear date
                        // Optional: Clear slots selection here if desired
                    } else {
                        // Collapse all others within this tab
                        allCards.removeClass('active-day border border-2 border-primary shadow');
                        allSlotSections.slideUp();
                        allIcons.html('<i class="fas fa-chevron-down"></i>');

                        // Activate clicked card
                        card.addClass('active-day border border-2 border-primary shadow');
                        slotSection.slideDown();
                        icon.html('<i class="fas fa-chevron-up"></i>');

                        // Set Date
                        $(dateInputId).val(date);

                        // Reset hours for new date
                        $(hoursInputId).val('');

                        // Load slots
                        loadAvailableHours(service, date, containerId, hoursInputId);
                    }
                });

                // Removed standalone handlers for poolDate and turfDate since we use the calendar UI now
                /*
                $('#poolDate').on('change', function () {
                    loadAvailableHours('pool', $(this).val(), '#poolHourOptions', '#poolSelectedHours');
                });
                */
            });
        </script>

        <script>
            $(document).ready(function () {
                // Form Submission Handler
                // Form Submission Handler - Redirect to Checkout OR Process Reschedule
                @if(isset($rescheduleBooking))
                    @php
                        $isGroupReschedule = isset($isGroupReschedule) && $isGroupReschedule;
                        $rescheduleRoute = $isGroupReschedule 
                            ? route('booking.process-reschedule.group', $rescheduleBooking->group_id ?? $rescheduleBooking->id)
                            : route('booking.process-reschedule', $rescheduleBooking->id);
                    @endphp
                    
                    // Reschedule Mode: Submit directly to process route
                    $('#turfForm, #poolForm').attr('action', "{{ $rescheduleRoute }}");
                    $('#turfForm, #poolForm').attr('method', "POST");

                    // Update button text
                    $('.btn-primary').html('<i class="fas fa-sync-alt me-2"></i> Confirm Reschedule');

                @else
                    // Normal Booking Mode
                    $('#turfForm, #poolForm').attr('action', "{{ route('checkout') }}");
                    $('#turfForm, #poolForm').attr('method', "POST");
                @endif

                // Validate before submit
                $('#turfForm, #poolForm').on('submit', function (e) {
                    const form = $(this);
                    const hoursInput = form.find('input[name="hours"]');

                    if (!hoursInput.val()) {
                        e.preventDefault();
                        Swal.fire({
                            icon: 'warning',
                            title: 'No Slot Selected',
                            text: 'Please select at least one time slot.'
                        });
                        return;
                    }
                });

                // jQuery UI Datepicker initialization
                $("#dateTurf").datepicker({
                    dateFormat: "yy-mm-dd",
                    minDate: 0,
                    showAnim: "slideDown",
                    changeMonth: true,
                    changeYear: true
                });

                $("#poolDate").datepicker({
                    dateFormat: "yy-mm-dd",
                    minDate: 0,
                    showAnim: "slideDown",
                    changeMonth: true,
                    changeYear: true
                });
            });
        </script>
    @endpush


</x-user.layout>