<x-user.layout>
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card shadow-lg border-0 rounded-lg">
                    <div class="card-header bg-gradient-primary text-white text-center py-4"
                        style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                        <h3 class="mb-0 fw-bold"><i class="fas fa-shopping-cart me-2"></i> Booking Summary</h3>
                        <p class="mb-0 opacity-75">Review your booking details before payment</p>
                    </div>
                    <div class="card-body p-5">

                        <div class="row mb-4">
                            <div class="col-md-6 border-end">
                                <h5 class="text-muted text-uppercase small fw-bold mb-3">Service Details</h5>
                                <div class="d-flex align-items-center mb-3">
                                    <div class="icon-box bg-light rounded-circle p-3 me-3 text-primary">
                                        <i
                                            class="fas {{ strtolower($service) == 'turf' ? 'fa-futbol' : 'fa-swimmer' }} fa-2x"></i>
                                    </div>
                                    <div>
                                        <h4 class="mb-0 fw-bold text-dark">
                                            {{ $service }}
                                        </h4>
                                        <span class="badge bg-success rounded-pill mt-1">Premium Facility</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6 ps-md-5">
                                <h5 class="text-muted text-uppercase small fw-bold mb-3">Booking Date</h5>
                                <div class="d-flex align-items-center">
                                    <i class="far fa-calendar-alt fa-2x text-secondary me-3"></i>
                                    <div>
                                        <h4 class="mb-0 fw-bold text-dark">
                                            {{ \Carbon\Carbon::parse($date)->format('d M, Y') }}
                                        </h4>
                                        <p class="text-muted mb-0">{{ \Carbon\Carbon::parse($date)->format('l') }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <hr class="my-4">

                        <h5 class="text-muted text-uppercase small fw-bold mb-3">Selected Time Slots</h5>
                        <div class="table-responsive mb-4">
                            <table class="table table-hover mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>Time Slot</th>
                                        <th class="text-end">Price</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($timeSlots as $slot)
                                        @php
                                            $dt = \Carbon\Carbon::parse($slot);
                                            $slotPrice = $slotPrices[$slot] ?? 0;
                                        @endphp
                                        <tr>
                                            <td>
                                                <i class="far fa-clock text-primary me-2"></i>
                                                {{ $dt->format('g:i A') }}
                                            </td>
                                            <td class="text-end fw-bold">₹{{ number_format($slotPrice, 2) }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <div class="bg-light p-4 rounded-3 border mb-4">
                            <div class="d-flex justify-content-between mb-2">
                                <span class="text-muted">Total Slots</span>
                                <span class="fw-bold">{{ count($timeSlots) }} slot(s)</span>
                            </div>
                            <hr>
                            <div class="d-flex justify-content-between align-items-center">
                                <span class="h5 mb-0 fw-bold text-dark">Total Amount</span>
                                <span class="h3 mb-0 fw-bold text-primary">₹{{ number_format($totalPrice, 2) }}</span>
                            </div>
                        </div>

                        <form action="{{ route('booking.confirm') }}" method="POST" id="confirmPaymentForm">
                            @csrf
                            <input type="hidden" name="booking_for_id" value="{{ $bookingForId }}">
                            <input type="hidden" name="date" value="{{ $date }}">
                            @foreach($timeSlots as $slot)
                                <input type="hidden" name="timeSlots[]" value="{{ $slot }}">
                            @endforeach
                            <input type="hidden" name="amount" value="{{ $totalPrice }}">

                            <!-- Hidden Fields for Razorpay Response -->
                            <input type="hidden" name="razorpay_payment_id" id="razorpay_payment_id">
                            <input type="hidden" name="razorpay_order_id" id="razorpay_order_id">
                            <input type="hidden" name="razorpay_signature" id="razorpay_signature">

                            <div class="d-grid gap-2">
                                <button type="button" id="payBtn"
                                    class="btn btn-primary btn-lg py-3 rounded-pill fw-bold shadow-sm hover-elevate">
                                    <i class="fas fa-lock me-2"></i> Pay & Confirm
                                    ₹{{ number_format($totalPrice) }}
                                </button>
                                <a href="{{ route('home') }}"
                                    class="btn btn-outline-secondary btn-lg py-3 rounded-pill fw-bold">
                                    <i class="fas fa-arrow-left me-2"></i> Go Back
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://checkout.razorpay.com/v1/checkout.js"></script>
    <script>
        document.getElementById('payBtn').onclick = function (e) {
            e.preventDefault();

            var paymentEnabled = {{ $paymentEnabled ? 'true' : 'false' }};
            var orderId = "{{ $orderId }}";

            if (!paymentEnabled) {
                // Bypass Mode
                document.getElementById('razorpay_payment_id').value = 'bypass_pay_' + Math.random().toString(36).substr(2, 9);
                document.getElementById('razorpay_order_id').value = orderId;
                document.getElementById('razorpay_signature').value = 'bypass_sig_' + Math.random().toString(36).substr(2, 9);

                // Change button text
                var btn = document.getElementById('payBtn');
                btn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i> Processing...';
                btn.disabled = true;

                document.getElementById('confirmPaymentForm').submit();
                return;
            }

            var options = {
                "key": "{{ config('services.razorpay.key') }}",
                "amount": "{{ $totalPrice * 100 }}", // Amount is in currency subunits. Default currency is INR. Hence, 50000 refers to 50000 paise
                "currency": "INR",
                "name": "Turf Booking",
                "description": "Booking Payment",
                "image": "{{ asset('user/assets/img/logo/logo.png') }}",
                "order_id": orderId,
                "handler": function (response) {
                    document.getElementById('razorpay_payment_id').value = response.razorpay_payment_id;
                    document.getElementById('razorpay_order_id').value = response.razorpay_order_id;
                    document.getElementById('razorpay_signature').value = response.razorpay_signature;

                    document.getElementById('confirmPaymentForm').submit();
                },
                "prefill": {
                    "name": "{{ auth()->user()->name }}",
                    "email": "{{ auth()->user()->email }}",
                    "contact": "{{ auth()->user()->phone ?? '' }}"
                },
                "theme": {
                    "color": "#3399cc"
                }
            };
            var rzp1 = new Razorpay(options);
            rzp1.on('payment.failed', function (response) {
                alert("Payment Failed: " + response.error.description);
            });
            rzp1.open();
        }
    </script>
    <style>
        .hover-elevate:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.15) !important;
        }
    </style>
</x-user.layout>