<!DOCTYPE html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description"
        content="viho admin is super flexible, powerful, clean &amp; modern responsive bootstrap 4 admin template with unlimited possibilities.">
    <meta name="keywords"
        content="admin template, viho admin template, dashboard template, flat admin template, responsive admin template, web app">
    <meta name="author" content="pixelstrap">
    <link rel="icon" href="{{ asset('admin/assets/images/favicon.png') }}" type="image/x-icon">
    <link rel="shortcut icon" href="{{ asset('admin/assets/images/favicon.png') }}" type="image/x-icon">
    <title>Core Ocean - Admin Panel Login</title>
    <!-- Google font-->
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link
        href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&amp;display=swap"
        rel="stylesheet">
    <link
        href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&amp;display=swap"
        rel="stylesheet">
    <link
        href="https://fonts.googleapis.com/css2?family=Rubik:ital,wght@0,400;0,500;0,600;0,700;0,800;0,900;1,300;1,400;1,500;1,600;1,700;1,800;1,900&amp;display=swap"
        rel="stylesheet">

    <!-- Flag icon-->
    <link rel="stylesheet" type="text/css" href="{{ asset('admin/assets/css/flag-icon.css') }}">
    <!-- Font Awesome-->
    <link rel="stylesheet" type="text/css" href="{{ asset('admin/assets/css/fontawesome.css') }}">
    <!-- Feather icon-->
    <link rel="stylesheet" type="text/css" href="{{ asset('admin/assets/css/feather-icon.css') }}">
    <!-- Bootstrap css-->
    <link rel="stylesheet" type="text/css" href="{{ asset('admin/assets/css/bootstrap.css') }}">
    <!-- App css-->
    <link rel="stylesheet" type="text/css" href="{{ asset('admin/assets/css/style.css') }}">
    <link id="color" rel="stylesheet" href="{{ asset('admin/assets/css/color-4.css') }}" media="screen">
    <link rel="stylesheet" type="text/css" href="{{ asset('admin/assets/css/sweetalert2.css') }}">
    <!-- Responsive css-->
    <link rel="stylesheet" type="text/css" href="{{ asset('admin/assets/css/responsive.css') }}">
</head>

<style>
    input {
        color: #000 !important;
    }

    input::placeholder {
        color: #030303 !important;
    }
</style>

<body>
    <!-- Loader starts-->
    <div class="loader-wrapper">
        <div class="theme-loader">
            <div class="loader-p"></div>
        </div>
    </div>
    <!-- Loader ends-->
    <!-- page-wrapper Start-->
    <section>
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-12">
                    <form class="theme-form login-form" id="signupForm">
                        <div class="col-12 mb-4 text-center">
                            <img src="{{ asset('admin/assets/images/logo/service-logo.png') }}" alt=""
                                style="height: 100px; width: auto" class="img-fluid">
                            <h4 class="mt-3">{{ env('APP_NAME') }}</h4>
                        </div>
                        @csrf

                        <div class="col-12 mb-2 text-center">
                            <span class="fs-6">Already have an account? <a href="{{ route('login') }}"> Login</a></span>
                        </div>

                        <h4>Register</h4>
                        <h6>Welcome back! Register in to your account</h6>

                        <div class="form-group">
                            <label>Username</label>
                            <div class="input-group"><span class="input-group-text"><i class="fa fa-user"></i></span>
                                <input class="form-control" type="text" name="name" id="name"
                                    placeholder="Enter Full Name">
                            </div>
                            <span class="text-danger error-text name_err"></span>
                        </div>

                        <div class="form-group">
                            <label>Mobile No.</label>
                            <div class="input-group"><span class="input-group-text"> <i class="fa fa-phone"></i>
                                </span>
                                <input class="form-control" type="tel" id="mobile" name="mobile"
                                    placeholder="Enter Mobile No.">
                            </div>
                            <span class="text-danger error-text email_err"></span>
                        </div>

                        <div class="form-group">
                            <label>Email ID</label>
                            <div class="input-group"><span class="input-group-text"> <i class="fa fa-envelope"
                                        style="font-size: 0.8rem"></i> </span>
                                <input class="form-control" type="email" id="email" name="email"
                                    placeholder="Enter Email Id">
                            </div>
                            <span class="text-danger error-text email_err"></span>
                        </div>
                        <div class="form-group">
                            <label>Password</label>
                            <div class="input-group"><span class="input-group-text"><i class="fa fa-lock"></i></span>
                                <input class="form-control" type="password" id="password" name="password"
                                    placeholder="*********">
                                <span class="input-group-text" id="password_eye" onclick="showHidePassword1()"><i
                                        class="eye fa fa-eye-slash"></i></span>
                            </div>
                            <span class="text-danger error-text password_err"></span>
                        </div>

                        <div class="form-group">
                            <label>Confirm Password</label>
                            <div class="input-group"><span class="input-group-text"><i class="fa fa-lock"></i></span>
                                <input class="form-control" type="password" id="confirm_password"
                                    name="confirm_password" placeholder="*********">
                                <span class="input-group-text" id="confirm_password_eye"
                                    onclick="showHidePassword2()"><i class="eye fa fa-eye-slash"></i></span>
                            </div>
                            <span class="text-danger error-text confirm_password_err"></span>
                        </div>

                        <div class="form-group my-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="agreed" name="agreed"
                                    required>
                                <label class="form-check-label text-dark" for="agreed">
                                    I agree to the <a href="/terms" target="_blank">Terms & Conditions</a> and <a
                                        href="/privacy" target="_blank">Privacy Policy</a>
                                </label>
                            </div>
                        </div>

                        <div class="form-group">
                            <button class="btn btn-primary btn-block m-auto" id="signupSubmit" disabled type="submit">Sign
                                in</button>
                        </div>

                    </form>
                    {{-- <div class="login-card">
                    </div> --}}
                </div>
            </div>
        </div>
    </section>

    <!-- latest jquery-->
    <script src="{{ asset('admin/assets/js/jquery-3.5.1.min.js') }}"></script>
    <!-- feather icon js-->
    <script src="{{ asset('admin/assets/js/icons/feather-icon/feather.min.js') }}"></script>
    <script src="{{ asset('admin/assets/js/icons/feather-icon/feather-icon.js') }}"></script>
    <!-- Sidebar jquery-->
    <script src="{{ asset('admin/assets/js/sidebar-menu.js') }}"></script>
    <script src="{{ asset('admin/assets/js/config.js') }}"></script>
    <!-- Bootstrap js-->
    <script src="{{ asset('admin/assets/js/bootstrap/popper.min.js') }}"></script>
    <script src="{{ asset('admin/assets/js/bootstrap/bootstrap.min.js') }}"></script>
    <!-- Theme js-->
    <script src="{{ asset('admin/assets/js/sweet-alert/sweetalert.min.js') }}"></script>
    <script src="{{ asset('admin/assets/js/script.js') }}"></script>
    <!-- login js-->

    <script>
        $("#signupForm").submit(function(e) {
            e.preventDefault();
            $("#signupSubmit").prop('disabled', true);
            var formdata = new FormData(this);
            $.ajax({
                url: '{{ route('register') }}',
                type: 'POST',
                data: formdata,
                contentType: false,
                processData: false,
                success: function(data) {
                    if (!data.error && !data.error2) {
                        // swal("Successful!", data.success, "success")
                        // .then((action) => {
                        window.location.href = '{{ route('login') }}';
                        // });
                    } else {
                        if (data.error2) {
                            swal("Error!", data.error2, "error");
                            $("#signupSubmit").prop('disabled', false);
                        } else {
                            $("#signupSubmit").prop('disabled', false);
                            resetErrors();
                            printErrMsg(data.error);
                        }
                    }
                },
                error: function(error) {
                    $("#signupSubmit").prop('disabled', false);
                    swal("Error occured!", "Something went wrong please try again", "error");
                },
            });

            function resetErrors() {
                var form = document.getElementById('loginForm');
                var data = new FormData(form);
                for (var [key, value] of data) {
                    console.log(key, value)
                    $('.' + key + '_err').text('');
                    $('#' + key).removeClass('is-invalid');
                    $('#' + key).addClass('is-valid');
                }
            }

            function printErrMsg(msg) {
                $.each(msg, function(key, value) {
                    console.log(key);
                    $('.' + key + '_err').text(value);
                    $('#' + key).addClass('is-invalid');
                });
            }

        });
    </script>

</body>

<script>
    showHidePassword1 = () => {
        var password = document.getElementById('password');
        var toggler = document.getElementById('password_eye');

        if (password.type == 'password') {
            password.setAttribute('type', 'text');

            toggler.querySelector('i').classList.remove('fa-eye-slash');
            toggler.querySelector('i').classList.add('fa-eye');
        } else {
            password.setAttribute('type', 'password');
            toggler.querySelector('i').classList.remove('fa-eye');
            toggler.querySelector('i').classList.add('fa-eye-slash');
        }
    }

    showHidePassword2 = () => {
        let confirmPassword = document.getElementById('confirm_password');
        let toggler = document.getElementById('confirm_password_eye');

        if (confirmPassword.type === 'password') {
            confirmPassword.setAttribute('type', 'text');
            toggler.querySelector('i').classList.remove('fa-eye-slash');
            toggler.querySelector('i').classList.add('fa-eye');
        } else {
            confirmPassword.setAttribute('type', 'password');
            toggler.querySelector('i').classList.remove('fa-eye');
            toggler.querySelector('i').classList.add('fa-eye-slash');
        }
    };
</script>


<script>
    $(document).ready(function() {
        // Function to check if all fields are filled
        function toggleSubmitButton() {
            const name = $('#name').val().trim();
            const mobile = $('#mobile').val().trim();
            const email = $('#email').val().trim();
            const password = $('#password').val().trim();
            const confirmPassword = $('#confirm_password').val().trim();
            const agreed = $('#agreed').is(':checked');

            if (name && mobile && email && password && confirmPassword && agreed) {
                $('#signupSubmit').prop('disabled', false);
            } else {
                $('#signupSubmit').prop('disabled', true);
            }
        }

        // Bind events to inputs and checkbox
        $('#name, #mobile, #email, #password, #confirm_password').on('input', toggleSubmitButton);
        $('#agreed').on('change', toggleSubmitButton);
    });
</script>


</html>
