<?php

namespace Database\Seeders;

use App\Models\BookingFor;
use App\Models\ServiceDetail;
use Illuminate\Database\Seeder;

class ServiceDetailsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get the booking_for records for turf and pool
        $turf = BookingFor::where('service', 'LIKE', '%turf%')->first();
        $pool = BookingFor::where('service', 'LIKE', '%pool%')->first();

        // Seed Turf Details (Premium Turf from image)
        if ($turf) {
            ServiceDetail::updateOrCreate(
                ['booking_for_id' => $turf->id],
                [
                    'name' => 'FIFA Standard Turf',
                    'category' => 'Premium Turf',
                    'location' => 'Professional grade facility',
                    'rating' => 4.8,
                    'icon' => null,
                    'availability' => '95%',
                    'capacity' => '22 players',
                    'area_size' => '100x60 meters',
                    'cost' => '₹500/hour',
                    'image' => null,
                    // Pool specific (null for turf)
                    'water_temp' => null,
                    'depth_range' => null,
                ]
            );
        }

        // Seed Pool Details (Olympic Pool from image)
        if ($pool) {
            ServiceDetail::updateOrCreate(
                ['booking_for_id' => $pool->id],
                [
                    'name' => 'Olympic Swimming Pool',
                    'category' => 'Olympic Pool',
                    'location' => 'Heated & filtered water',
                    'rating' => 4.9,
                    'icon' => null,
                    'availability' => null,
                    'capacity' => null,
                    'area_size' => '50 meters',
                    'cost' => '₹300/hour',
                    'image' => null,
                    // Pool specific
                    'water_temp' => 28.0,
                    'depth_range' => '1.2-2m',
                ]
            );
        }
    }
}
