<?php

declare(strict_types=1);

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;

class PermissionTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $permissions = [
            [
                'id'    => 1,
                'name'  => 'dashboard.view',
            ],
            [
                'id'    => 2,
                'name'  => 'users.view',
            ],
            [
                'id'    => 3,
                'name'  => 'users.create',
            ],
            [
                'id'    => 4,
                'name'  => 'users.edit',
            ],
            [
                'id'    => 5,
                'name'  => 'users.delete',
            ],
            [
                'id'    => 6,
                'name'  => 'users.view_profile',
            ],
            [
                'id'    => 7,
                'name'  => 'users.change_password',
            ],
            [
                'id'    => 8,
                'name'  => 'booking_slots.index',
            ],
            [
                'id'    => 9,
                'name'  => 'special_booking_slots.index',
            ],
            [
                'id'    => 10,
                'name'  => 'booked_list.view',
            ],

        ];

        foreach ($permissions as $permission)
        {
            Permission::updateOrCreate([
                'id' => $permission['id'],
            ], [
                'id'    => $permission['id'],
                'name'  => $permission['name'],
            ]);
        }
    }
}
