<?php

use App\Models\BookingFor;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('service_details', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(BookingFor::class)->constrained()->cascadeOnDelete();

            // Common fields
            $table->string('name');                          // e.g., "FIFA Standard Turf", "Olympic Swimming Pool"
            $table->string('category')->nullable();          // e.g., "Premium Turf", "Olympic Pool"
            $table->text('location')->nullable();            // e.g., "Professional grade facility", "Heated & filtered water"
            $table->decimal('rating', 2, 1)->default(0);     // e.g., 4.8, 4.9
            $table->string('icon')->nullable();              // Icon path for the service
            $table->string('availability')->nullable();      // e.g., "95%"
            $table->string('capacity')->nullable();          // e.g., "22 players"
            $table->string('area_size')->nullable();         // e.g., "100x60 meters", "50 meters"
            $table->string('cost')->nullable();              // e.g., "₹500/hour"
            $table->string('image')->nullable();             // Image path for the service

            // Pool specific fields
            $table->decimal('water_temp', 4, 1)->nullable();     // e.g., 28.0 °C
            $table->string('depth_range')->nullable();           // e.g., "1.2-2m"

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('service_details');
    }
};
