<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('old_booked_slots', function (Blueprint $table) {
            $table->id();
            $table->string('group_id', 36)->nullable()->index();
            $table->foreignId('booking_for_id')->constrained('booking_fors')->cascadeOnDelete();
            $table->foreignId('user_id')->constrained('users')->cascadeOnDelete();
            $table->date('date');
            $table->time('time');
            $table->decimal('amount', 8, 2);
            $table->unsignedTinyInteger('status');
            $table->unsignedTinyInteger('payment_status');
            $table->foreignId('transaction_id')->nullable()->constrained('transactions')->nullOnDelete();
            $table->timestamp('rescheduled_at')->nullable(); // When this slot was moved to old_booked_slots
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('old_booked_slots');
    }
};
