<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('transactions', function (Blueprint $table) {
            if (!Schema::hasColumn('transactions', 'booking_id')) {
                $table->unsignedBigInteger('booking_id')->nullable();
            }
            if (!Schema::hasColumn('transactions', 'user_id')) {
                $table->unsignedBigInteger('user_id')->nullable(); // Make nullable temporarily or handle default? Assuming table might be empty or we're okay.
            }
            if (!Schema::hasColumn('transactions', 'amount')) {
                $table->decimal('amount', 10, 2)->default(0);
            }
            if (!Schema::hasColumn('transactions', 'currency')) {
                $table->string('currency', 3)->default('INR');
            }
            if (!Schema::hasColumn('transactions', 'transaction_type')) {
                $table->string('transaction_type')->nullable(); // 'payment', 'refund', 'reschedule_payment', 'reschedule_refund'
            }
            if (!Schema::hasColumn('transactions', 'status')) {
                $table->string('status')->default('pending');
            }
            if (!Schema::hasColumn('transactions', 'razorpay_payment_id')) {
                $table->string('razorpay_payment_id')->nullable();
            }
            if (!Schema::hasColumn('transactions', 'razorpay_order_id')) {
                $table->string('razorpay_order_id')->nullable();
            }
            if (!Schema::hasColumn('transactions', 'razorpay_refund_id')) {
                $table->string('razorpay_refund_id')->nullable();
            }
            if (!Schema::hasColumn('transactions', 'description')) {
                $table->text('description')->nullable();
            }

            // Re-add foreign key if needed/missing. Avoiding duplications is harder, assume safe to skip if constraint exists, but checking constraint existence is db-specific.
            // Simplified: Just ensure columns are there.
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('transactions', function (Blueprint $table) {
            //
        });
    }
};
