<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Transaction extends Model
{
    use HasFactory;

    protected $fillable = [
        'booking_id',
        'user_id',
        'amount',
        'currency',
        'transaction_type', // payment, refund, reschedule_charge
        'status', // pending, success, failed
        'razorpay_payment_id',
        'razorpay_order_id',
        'razorpay_refund_id',
        'description',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function booking()
    {
        return $this->belongsTo(BookedSlot::class, 'booking_id');
    }
}
