<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class OldBookedSlot extends Model
{
    protected $fillable = [
        'group_id',
        'booking_for_id',
        'user_id',
        'date',
        'time',
        'amount',
        'status',
        'payment_status',
        'transaction_id',
        'rescheduled_at'
    ];

    protected $casts = [
        'rescheduled_at' => 'datetime',
    ];

    public function bookingFor()
    {
        return $this->belongsTo(BookingFor::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function transaction()
    {
        return $this->belongsTo(Transaction::class);
    }
}
