<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BookedSlot extends Model
{
    protected $fillable = [
        'group_id',
        'booking_for_id',
        'user_id',
        'date',
        'time',
        'amount',
        'status',
        'payment_status',
        'transaction_id'
    ];

    public function transaction()
    {
        return $this->belongsTo(Transaction::class);
    }

    public function bookingFor()
    {
        return $this->belongsTo(BookingFor::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
