<?php

namespace App\Http\Controllers\Masters;

use App\Http\Controllers\BaseController;
use App\Http\Requests\Master\StoreSpecialSlotRequest;
use App\Models\BookingFor;
use App\Models\SpecialBookingSlot;
use Illuminate\Http\Request;
use Exception;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;

class SpecialBookingController extends BaseController
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $services = BookingFor::get();
        $specialBooking = SpecialBookingSlot::latest()->get();

        return view('admin.masters.special_booking')->with(['specialBooking' => $specialBooking, 'services' => $services]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreSpecialSlotRequest $request)
    {
        try
        {
            DB::beginTransaction();
            $input = $request->validated();
            if (isset($input['logo']))
            {
                $input['logo'] = 'storage/'.$request->file('logo')->store('brands', 'public');
            }
            SpecialBookingSlot::create(Arr::only($input, SpecialBookingSlot::getFillables()));
            DB::commit();

            return response()->json(['success' => 'Special slot created successfully!']);
        }
        catch (Exception $e)
        {
            return $this->respondWithAjax($e, 'creating', 'Special slot');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(SpecialBookingSlot $special_booking_slot)
    {
        return [
            'specialSlot' => $special_booking_slot,
        ];
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(StoreSpecialSlotRequest $request, SpecialBookingSlot $special_booking_slot)
    {
        try
        {
            DB::beginTransaction();
            $input = $request->validated();

            $special_booking_slot->update(Arr::only($input, SpecialBookingSlot::getFillables()));
            DB::commit();

            return response()->json(['success' => 'Special slot created successfully!']);
        }
        catch (Exception $e)
        {
            return $this->respondWithAjax($e, 'creating', 'Special slot');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
